"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const apollo_1 = require("@nestjs/apollo");
const graphql_1 = require("@nestjs/graphql");
const user_module_1 = require("./app/user/user.module");
const config_1 = require("@nestjs/config");
const path_1 = require("path");
const default_1 = require("@apollo/server/plugin/landingPage/default");
const instansi_module_1 = require("./app/instansi/instansi.module");
const pegawai_module_1 = require("./app/pegawai/pegawai.module");
const lokasi_presensi_module_1 = require("./app/lokasi_presensi/lokasi-presensi.module");
const map_pegawai_lokasi_presensi_module_1 = require("./app/map_pegawai_lokasi_presensi/map-pegawai-lokasi-presensi.module");
const skema_presensi_module_1 = require("./app/skema_presensi/skema-presensi.module");
const jadwal_kerja_module_1 = require("./app/jadwal_kerja/jadwal-kerja.module");
const auth_module_1 = require("./app/auth/auth.module");
const menu_module_1 = require("./app/menu/menu.module");
const menu_manage_module_1 = require("./app/menu_manage/menu_manage_module");
const user_service_1 = require("./app/user/services/user.service");
const kehadiran_modules_1 = require("./app/kehadiran/kehadiran.modules");
const riwayat_presensi_module_1 = require("./app/riwayat_presensi/riwayat_presensi.module");
const user_level_module_1 = require("./app/user_level/user_level.module");
const pubsub_module_1 = require("./core/pubsub/pubsub.module");
const dashboard_module_1 = require("./app/dashboard/dashboard.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                isGlobal: true,
                envFilePath: ['.env'],
            }),
            graphql_1.GraphQLModule.forRootAsync({
                driver: apollo_1.ApolloDriver,
                useFactory: async (config, userService) => ({
                    subscriptions: {
                        'graphql-ws': {
                            path: '/graphql',
                        },
                    },
                    cors: {
                        origin: '*',
                    },
                    autoSchemaFile: (0, path_1.join)(process.cwd(), 'src/schema.gql'),
                    playground: false,
                    introspection: true,
                    debug: true,
                    sortSchema: true,
                    autoTransformHttpErrors: true,
                    plugins: [(0, default_1.ApolloServerPluginLandingPageLocalDefault)({ footer: true })],
                    context: ({ req }) => ({
                        req,
                        userService,
                    }),
                }),
                inject: [config_1.ConfigService, user_service_1.UserService],
                imports: [user_module_1.UserModule],
            }),
            user_module_1.UserModule,
            instansi_module_1.InstansiModule,
            pegawai_module_1.PegawaiModule,
            lokasi_presensi_module_1.LokasiPresensiModule,
            map_pegawai_lokasi_presensi_module_1.MapPegawaiLokasiPresensiModule,
            skema_presensi_module_1.SkemaPresensiModule,
            jadwal_kerja_module_1.JadwalKerjaModule,
            auth_module_1.AuthModule,
            menu_module_1.MenuModule,
            menu_manage_module_1.MenuManageModule,
            kehadiran_modules_1.KehadiranModule,
            riwayat_presensi_module_1.RiwayatPresensiModule,
            user_level_module_1.UserLevelModule,
            pubsub_module_1.PubSubModule,
            dashboard_module_1.DashboardModule,
        ],
    })
], AppModule);
