import { Auth } from './entities/auth.entity';
import { LoginWebAuthInput } from './dto/login-web-auth.input';
import { InterfaceAuthService } from './services/interface.auth.service';
import { MeAuth } from './entities/me-auth.entity';
import { IJwtPayload } from './jwt/types.jwt';
import { LoginMobileAppAuthInput } from './dto/login-mobile-app-auth.input';
export declare class AuthResolver {
    private readonly _authService;
    constructor(_authService: InterfaceAuthService<Auth>);
    loginWeb(loginWebAuthInput: LoginWebAuthInput): Promise<Auth>;
    loginMobileApp(loginMobileAppAuthInput: LoginMobileAppAuthInput): Promise<Auth>;
    authMe(user: IJwtPayload): Promise<MeAuth>;
    refreshToken(user: IJwtPayload, context: any): Promise<Auth>;
}
