"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const auth_entity_1 = require("./entities/auth.entity");
const login_web_auth_input_1 = require("./dto/login-web-auth.input");
const common_1 = require("@nestjs/common");
const auth_guard_jwt_1 = require("./jwt/auth-guard.jwt");
const me_auth_entity_1 = require("./entities/me-auth.entity");
const current_user_decorator_jwt_1 = require("./decorators/current-user.decorator.jwt");
const auth_guard_jwt_refresh_1 = require("./jwt/auth-guard.jwt-refresh");
const login_mobile_app_auth_input_1 = require("./dto/login-mobile-app-auth.input");
let AuthResolver = class AuthResolver {
    _authService;
    constructor(_authService) {
        this._authService = _authService;
    }
    loginWeb(loginWebAuthInput) {
        return this._authService.doLoginWeb(loginWebAuthInput);
    }
    loginMobileApp(loginMobileAppAuthInput) {
        return this._authService.doLoginMobileApp(loginMobileAppAuthInput);
    }
    async authMe(user) {
        return await this._authService.me(user.user_id);
    }
    async refreshToken(user, context) {
        const refreshToken = context.req.headers['authorization']?.replace('Bearer ', '');
        return await this._authService.generateRefreshTokens(user.user_id, refreshToken);
    }
};
exports.AuthResolver = AuthResolver;
__decorate([
    (0, graphql_1.Mutation)(() => auth_entity_1.Auth),
    __param(0, (0, graphql_1.Args)('loginWebAuthInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [login_web_auth_input_1.LoginWebAuthInput]),
    __metadata("design:returntype", void 0)
], AuthResolver.prototype, "loginWeb", null);
__decorate([
    (0, graphql_1.Mutation)(() => auth_entity_1.Auth),
    __param(0, (0, graphql_1.Args)('loginMobileAppAuthInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [login_mobile_app_auth_input_1.LoginMobileAppAuthInput]),
    __metadata("design:returntype", void 0)
], AuthResolver.prototype, "loginMobileApp", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => me_auth_entity_1.MeAuth, { name: 'authMe' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AuthResolver.prototype, "authMe", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_refresh_1.AuthGuardJwtRefresh),
    (0, graphql_1.Mutation)(() => auth_entity_1.Auth, { name: 'refreshToken' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __param(1, (0, graphql_1.Context)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], AuthResolver.prototype, "refreshToken", null);
exports.AuthResolver = AuthResolver = __decorate([
    (0, graphql_1.Resolver)(() => auth_entity_1.Auth),
    __param(0, (0, common_1.Inject)('IAuthService')),
    __metadata("design:paramtypes", [Object])
], AuthResolver);
