"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isQr = exports.isPegawai = exports.isAdminInstansi = exports.isSuperAdmin = exports.UserLevel = exports.jwtConstants = void 0;
exports.jwtConstants = {
    secret: 'yourSecretKey',
    accessTokenExpiresIn: '1h',
    refreshTokenExpiresIn: '1d',
};
var UserLevel;
(function (UserLevel) {
    UserLevel["SUPER_ADMIN"] = "8fb17e1f-a71b-4728-88b0-4e6ae37f40cc";
    UserLevel["ADMIN_INSTANSI"] = "9f341ba6-7aad-497e-8f51-6a8b5d0c2943";
    UserLevel["PEGAWAI"] = "7810b031-34d3-4cee-b10d-79604e20126d";
    UserLevel["QR"] = "b6b8cb03-6949-4dcf-ac42-3236d99b9b1c";
})(UserLevel || (exports.UserLevel = UserLevel = {}));
const isSuperAdmin = (userLevelId) => userLevelId === UserLevel.SUPER_ADMIN;
exports.isSuperAdmin = isSuperAdmin;
const isAdminInstansi = (userLevelId) => userLevelId === UserLevel.ADMIN_INSTANSI;
exports.isAdminInstansi = isAdminInstansi;
const isPegawai = (userLevelId) => userLevelId === UserLevel.PEGAWAI;
exports.isPegawai = isPegawai;
const isQr = (userLevelId) => userLevelId === UserLevel.QR;
exports.isQr = isQr;
