"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrentUser = void 0;
const common_1 = require("@nestjs/common");
const graphql_1 = require("@nestjs/graphql");
exports.CurrentUser = (0, common_1.createParamDecorator)(async (data, context) => {
    const ctx = graphql_1.GqlExecutionContext.create(context);
    const gqlCtx = ctx.getContext();
    const req = gqlCtx.req;
    return {
        user_id: req.user.user_id,
        user: {
            user_level_id: req.user.user_level_id,
            instansi_id: req.user.instansi_id,
            pegawai_id: req.user.pegawai_id,
        },
    };
});
