"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthGuardJwt = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const core_1 = require("@nestjs/core");
const graphql_1 = require("@nestjs/graphql");
const role_decorator_1 = require("../decorators/role.decorator");
const jwt_1 = require("@nestjs/jwt");
let AuthGuardJwt = class AuthGuardJwt extends (0, passport_1.AuthGuard)('jwt') {
    reflector;
    constructor(reflector) {
        super();
        this.reflector = reflector;
    }
    getRequest(context) {
        const ctx = graphql_1.GqlExecutionContext.create(context);
        return ctx.getContext().req;
    }
    async canActivate(context) {
        const activated = (await super.canActivate(context));
        const ctx = graphql_1.GqlExecutionContext.create(context);
        const gqlCtx = ctx.getContext();
        const req = gqlCtx.req;
        const allowedRoles = this.reflector.getAllAndOverride(role_decorator_1.ROLES_KEY, [
            context.getHandler(),
            context.getClass(),
        ]);
        const userId = req.user?.user_id;
        if (!userId)
            throw new common_1.UnauthorizedException('User ID tidak ditemukan di token');
        const user = await gqlCtx.userService.findOne({
            id: req.user.user_id,
        });
        if (!user)
            throw new common_1.UnauthorizedException('User tidak ditemukan');
        req.user = {
            user_id: user.id,
            user_level_id: user.user_level_id,
            instansi_id: user.instansi_id,
            pegawai_id: user.pegawai_id,
        };
        if (allowedRoles && !allowedRoles.includes(user.user_level_id)) {
            throw new common_1.UnauthorizedException('Akses ditolak: level user tidak sesuai');
        }
        return activated;
    }
    handleRequest(err, user, info) {
        if (info instanceof jwt_1.TokenExpiredError) {
            throw new common_1.UnauthorizedException('Token sudah kedaluwarsa');
        }
        if (err || !user) {
            throw err || new common_1.UnauthorizedException('Unauthorized');
        }
        return user;
    }
};
exports.AuthGuardJwt = AuthGuardJwt;
exports.AuthGuardJwt = AuthGuardJwt = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.Reflector])
], AuthGuardJwt);
