import { InterfaceAuthService } from './interface.auth.service';
import { LoginWebAuthInput } from '../dto/login-web-auth.input';
import { Auth } from '../entities/auth.entity';
import { InterfaceUserService } from '../../user/services/interface.user.service';
import { User } from '../../user/entities/user.entity';
import { JwtService } from '@nestjs/jwt';
import { MeAuth } from '../entities/me-auth.entity';
import { LoginMobileAppAuthInput } from '../dto/login-mobile-app-auth.input';
export declare class AuthService implements InterfaceAuthService<Auth> {
    private readonly _userService;
    private readonly _jwtService;
    constructor(_userService: InterfaceUserService<User>, _jwtService: JwtService);
    doLoginMobileApp(data: LoginMobileAppAuthInput): Promise<Auth>;
    me(userId: string): Promise<MeAuth>;
    doLoginWeb(data: LoginWebAuthInput): Promise<Auth>;
    private _generateTokens;
    generateRefreshTokens(userId: string, refreshToken: string): Promise<Auth>;
}
