"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const encrypt_helpers_1 = require("../../../core/helpers/encrypt.helpers");
const jwt_1 = require("@nestjs/jwt");
const constants_1 = require("../constants");
let AuthService = class AuthService {
    _userService;
    _jwtService;
    constructor(_userService, _jwtService) {
        this._userService = _userService;
        this._jwtService = _jwtService;
    }
    async doLoginMobileApp(data) {
        const getUser = await this._userService.findOne({
            user_username: data.username,
        });
        if (!getUser)
            throw new common_1.UnauthorizedException('Data pengguna tidak ditemukan');
        const isPasswordValid = await (0, encrypt_helpers_1.compareHash)(data.password, getUser.user_password);
        if (!isPasswordValid)
            throw new common_1.UnauthorizedException('Username dan password tidak sesuai');
        const allowedLevelId = '7810b031-34d3-4cee-b10d-79604e20126d';
        if (getUser.user_level_id !== allowedLevelId) {
            throw new common_1.UnauthorizedException('Akun tidak diizinkan untuk Mobile App');
        }
        const deviceOwner = await this._userService.findOne({
            user_mobile_device_id: data.device_id,
        });
        if (deviceOwner && deviceOwner.id !== getUser.id) {
            throw new common_1.UnauthorizedException('Perangkat sudah digunakan oleh akun lain');
        }
        if (getUser.user_mobile_device_id && getUser.user_mobile_device_id !== data.device_id) {
            throw new common_1.UnauthorizedException('Akun ini sudah terikat dengan perangkat lain');
        }
        if (!getUser.user_mobile_device_id) {
            await this._userService.update(getUser.id, { user_mobile_device_id: data.device_id });
        }
        return this._generateTokens(getUser.id);
    }
    async me(userId) {
        const user = await this._userService.findOne({ id: userId });
        if (!user)
            throw new common_1.UnauthorizedException('User not found');
        return {
            user_id: userId,
            user_nama: user.user_nama,
            user_level_id: user.user_level_id,
            instansi_id: user.instansi_id,
            pegawai_id: user.pegawai_id,
        };
    }
    async doLoginWeb(data) {
        const getUser = await this._userService.findOne({
            user_username: data.username,
        });
        if (!getUser)
            throw new common_1.UnauthorizedException('Data pengguna tidak ditemukan');
        if (!(await (0, encrypt_helpers_1.compareHash)(data.password, getUser.user_password)))
            throw new common_1.UnauthorizedException('Username dan password tidak sesuai');
        const allowedUserLevelIds = [
            '8fb17e1f-a71b-4728-88b0-4e6ae37f40cc',
            '9f341ba6-7aad-497e-8f51-6a8b5d0c2943',
            'b6b8cb03-6949-4dcf-ac42-3236d99b9b1c'
        ];
        if (!allowedUserLevelIds.includes(getUser.user_level_id)) {
            throw new common_1.UnauthorizedException('Akun tidak diizinkan');
        }
        return await this._generateTokens(getUser.id);
    }
    async _generateTokens(userId) {
        const accessToken = await this._jwtService.signAsync({ data: { user_id: userId } }, { expiresIn: constants_1.jwtConstants.accessTokenExpiresIn });
        const refreshToken = await this._jwtService.signAsync({ data: { user_id: userId } }, { expiresIn: constants_1.jwtConstants.refreshTokenExpiresIn });
        this._userService
            .update(userId, { user_refresh_token: refreshToken })
            .then();
        return {
            access_token: accessToken,
            refresh_token: refreshToken,
            user_id: userId,
        };
    }
    async generateRefreshTokens(userId, refreshToken) {
        const foundUser = await this._userService.findOne({
            id: userId,
            user_refresh_token: refreshToken,
        });
        if (!foundUser)
            throw new common_1.UnauthorizedException('Invalid user for refresh');
        return this._generateTokens(foundUser.id);
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IUserService')),
    __metadata("design:paramtypes", [Object, jwt_1.JwtService])
], AuthService);
