"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const common_1 = require("@nestjs/common");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const current_user_decorator_jwt_1 = require("../auth/decorators/current-user.decorator.jwt");
const overview_dashboard_response_1 = require("./dto/overview-dashboard.response");
const role_decorator_1 = require("../auth/decorators/role.decorator");
const constants_1 = require("../auth/constants");
let DashboardResolver = class DashboardResolver {
    _dashboardService;
    constructor(_dashboardService) {
        this._dashboardService = _dashboardService;
    }
    async dashboardOverview(user) {
        return this._dashboardService.overview(user);
    }
};
exports.DashboardResolver = DashboardResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Query)(() => overview_dashboard_response_1.OverviewDashboardResponse, { name: 'dashboardOverview' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DashboardResolver.prototype, "dashboardOverview", null);
exports.DashboardResolver = DashboardResolver = __decorate([
    (0, graphql_1.Resolver)(),
    __param(0, (0, common_1.Inject)('IDashboardService')),
    __metadata("design:paramtypes", [Object])
], DashboardResolver);
