"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../../auth/constants");
let DashboardService = class DashboardService {
    _jadwalKerjaService;
    constructor(_jadwalKerjaService) {
        this._jadwalKerjaService = _jadwalKerjaService;
    }
    async overview(user) {
        const today = new Date().toISOString().split('T')[0];
        const qb = this._jadwalKerjaService
            .mainRepositories()
            .mainDatasource()
            .createQueryBuilder('jadwal_kerja')
            .leftJoinAndSelect('jadwal_kerja.pegawai', 'pegawai')
            .leftJoinAndSelect('pegawai.instansi', 'instansi')
            .where('jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk = :today', {
            today,
        });
        if ((0, constants_1.isAdminInstansi)(user.user.user_level_id)) {
            qb.andWhere('pegawai.instansi_id = :instansi_id', {
                instansi_id: user.user.instansi_id,
            });
        }
        const jadwalHariIni = await qb.getMany();
        let presensi_masuk = 0;
        let belum_presensi_masuk = 0;
        let presensi_pulang = 0;
        let belum_presensi_pulang = 0;
        const daftar_masuk = [];
        const daftar_pulang = [];
        for (const jadwal of jadwalHariIni) {
            const pegawai = jadwal.pegawai;
            const instansi = pegawai?.instansi;
            const baseItem = {
                pegawai_nama: pegawai?.pegawai_nama || 'Tanpa Nama',
                instansi_nama: instansi?.instansi_nama || 'Tanpa Instansi',
                jadwal_kerja_presensi_jam_masuk: jadwal.jadwal_kerja_presensi_jam_masuk || null,
                jadwal_kerja_presensi_jam_pulang: jadwal.jadwal_kerja_presensi_jam_pulang || null,
            };
            if (jadwal.jadwal_kerja_presensi_jam_masuk) {
                presensi_masuk++;
                daftar_masuk.push(baseItem);
            }
            else {
                belum_presensi_masuk++;
            }
            if (jadwal.jadwal_kerja_presensi_jam_pulang) {
                presensi_pulang++;
                daftar_pulang.push(baseItem);
            }
            else {
                belum_presensi_pulang++;
            }
        }
        return {
            presensi_masuk,
            belum_presensi_masuk,
            presensi_pulang,
            belum_presensi_pulang,
            daftar_masuk,
            daftar_pulang,
        };
    }
};
exports.DashboardService = DashboardService;
exports.DashboardService = DashboardService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IJadwalKerjaService')),
    __metadata("design:paramtypes", [Object])
], DashboardService);
