import { Instansi } from './entities/instansi.entity';
import { InterfaceInstansiService } from './services/interface.instansi.service';
import { CreateInstansiInput } from './dto/create-instansi.input';
import { UpdateInstansiInput } from './dto/update-instansi.input';
import { LokasiPresensi } from '../lokasi_presensi/entities/lokasi-presensi.entity';
import { InterfaceLokasiPresensiService } from '../lokasi_presensi/services/interface.lokasi-presensi.service';
import { IJwtPayload } from '../auth/jwt/types.jwt';
export declare class InstansiResolver {
    private readonly _instansiService;
    private readonly lokasiPresensiService;
    constructor(_instansiService: InterfaceInstansiService<Instansi>, lokasiPresensiService: InterfaceLokasiPresensiService<LokasiPresensi>);
    createAgency(createInstansiInput: CreateInstansiInput): Promise<Instansi>;
    findAll(user: IJwtPayload): Promise<Instansi[]>;
    findOne(instansi_id: string): Promise<Instansi | null>;
    updateAgency(instansi_id: string, updateInstansiInput: UpdateInstansiInput): Promise<Instansi | null>;
    removeAgency(instansi_id: string): Promise<Instansi | null>;
    removeAgencyBatch(instansiIds: string[]): Promise<Instansi[]>;
    lokasiPresensi(instansi: Instansi): Promise<LokasiPresensi[]>;
}
