"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstansiResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const instansi_entity_1 = require("./entities/instansi.entity");
const common_1 = require("@nestjs/common");
const create_instansi_input_1 = require("./dto/create-instansi.input");
const update_instansi_input_1 = require("./dto/update-instansi.input");
const lokasi_presensi_entity_1 = require("../lokasi_presensi/entities/lokasi-presensi.entity");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const current_user_decorator_jwt_1 = require("../auth/decorators/current-user.decorator.jwt");
let InstansiResolver = class InstansiResolver {
    _instansiService;
    lokasiPresensiService;
    constructor(_instansiService, lokasiPresensiService) {
        this._instansiService = _instansiService;
        this.lokasiPresensiService = lokasiPresensiService;
    }
    async createAgency(createInstansiInput) {
        return this._instansiService.doCreate(createInstansiInput);
    }
    async findAll(user) {
        let where = {};
        if (user.user.user_level_id === '9f341ba6-7aad-497e-8f51-6a8b5d0c2943') {
            where = {
                ...where,
                id: user.user.instansi_id,
            };
        }
        return this._instansiService.findAll(where);
    }
    findOne(instansi_id) {
        return this._instansiService.findOne({ id: instansi_id });
    }
    updateAgency(instansi_id, updateInstansiInput) {
        return this._instansiService.update(instansi_id, updateInstansiInput);
    }
    removeAgency(instansi_id) {
        return this._instansiService.destroy(instansi_id);
    }
    async removeAgencyBatch(instansiIds) {
        return await this._instansiService.destroyBatch(instansiIds);
    }
    async lokasiPresensi(instansi) {
        const { id } = instansi;
        return this.lokasiPresensiService.findAll({ instansi_id: id });
    }
};
exports.InstansiResolver = InstansiResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => instansi_entity_1.Instansi),
    __param(0, (0, graphql_1.Args)('createInstansiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_instansi_input_1.CreateInstansiInput]),
    __metadata("design:returntype", Promise)
], InstansiResolver.prototype, "createAgency", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [instansi_entity_1.Instansi], { name: 'agencies' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], InstansiResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => instansi_entity_1.Instansi, { name: 'agency', nullable: true }),
    __param(0, (0, graphql_1.Args)('instansi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], InstansiResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => instansi_entity_1.Instansi),
    __param(0, (0, graphql_1.Args)('instansi_id', { type: () => String })),
    __param(1, (0, graphql_1.Args)('updateInstansiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_instansi_input_1.UpdateInstansiInput]),
    __metadata("design:returntype", void 0)
], InstansiResolver.prototype, "updateAgency", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => instansi_entity_1.Instansi),
    __param(0, (0, graphql_1.Args)('instansi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], InstansiResolver.prototype, "removeAgency", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => [instansi_entity_1.Instansi]),
    __param(0, (0, graphql_1.Args)('instansiIds', { type: () => [String] })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], InstansiResolver.prototype, "removeAgencyBatch", null);
__decorate([
    (0, graphql_1.ResolveField)('lokasi_presensi', () => [lokasi_presensi_entity_1.LokasiPresensi]),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [instansi_entity_1.Instansi]),
    __metadata("design:returntype", Promise)
], InstansiResolver.prototype, "lokasiPresensi", null);
exports.InstansiResolver = InstansiResolver = __decorate([
    (0, graphql_1.Resolver)(() => instansi_entity_1.Instansi),
    __param(0, (0, common_1.Inject)('IInstansiService')),
    __param(1, (0, common_1.Inject)('ILokasiPresensiService')),
    __metadata("design:paramtypes", [Object, Object])
], InstansiResolver);
