import { JadwalKerja } from './entities/jadwal-kerja.entity';
import { InterfaceJadwalKerjaService } from './services/interface.jadwal-kerja.service';
import { CreateJadwalKerjaInput } from './dto/create-jadwal-kerja.input';
import { InterfacePegawaiService } from '../pegawai/services/interface.pegawai.service';
import { Pegawai } from '../pegawai/entities/pegawai.entity';
import { CreateJadwalKerjaInputBatch } from './dto/create-jadwal-kerja-batch.input';
import { IJwtPayload } from '../auth/jwt/types.jwt';
export declare class JadwalKerjaResolver {
    private readonly _jadwalKerjaService;
    private readonly _pegawaiService;
    constructor(_jadwalKerjaService: InterfaceJadwalKerjaService<JadwalKerja>, _pegawaiService: InterfacePegawaiService<Pegawai>);
    createWorkScheduleBatch(createJadwalKerjaInputBatch: CreateJadwalKerjaInputBatch): Promise<JadwalKerja[]>;
    createWorkSchedule(createJadwalKerjaInput: CreateJadwalKerjaInput): Promise<JadwalKerja>;
    findAll(pegawaiId?: string | null): Promise<JadwalKerja[]>;
    findAllMe(user: IJwtPayload, jadwalKerjaPresensiTanggalMasuk?: string | null, jadwalKerjaPresensiTanggalPulang?: string | null): Promise<JadwalKerja[]>;
    workScheduleByDateAndInstancie(user: IJwtPayload, jadwalKerjaPresensiTanggalMasuk?: string | null, instansiId?: string | null): Promise<JadwalKerja[]>;
    findOne(jadwal_kerja_id: string): Promise<JadwalKerja | null>;
    removeWorkSchedule(jadwal_kerja_id: string): Promise<JadwalKerja | null>;
    removeWorkScheduleBatch(jadwalKerjaIds: string[]): Promise<JadwalKerja[]>;
    pegawai(jadwalKerja: JadwalKerja): Promise<Pegawai | null>;
}
