"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JadwalKerjaResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const jadwal_kerja_entity_1 = require("./entities/jadwal-kerja.entity");
const common_1 = require("@nestjs/common");
const create_jadwal_kerja_input_1 = require("./dto/create-jadwal-kerja.input");
const create_jadwal_kerja_batch_input_1 = require("./dto/create-jadwal-kerja-batch.input");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const current_user_decorator_jwt_1 = require("../auth/decorators/current-user.decorator.jwt");
const role_decorator_1 = require("../auth/decorators/role.decorator");
const constants_1 = require("../auth/constants");
let JadwalKerjaResolver = class JadwalKerjaResolver {
    _jadwalKerjaService;
    _pegawaiService;
    constructor(_jadwalKerjaService, _pegawaiService) {
        this._jadwalKerjaService = _jadwalKerjaService;
        this._pegawaiService = _pegawaiService;
    }
    createWorkScheduleBatch(createJadwalKerjaInputBatch) {
        return this._jadwalKerjaService.doCreateBatch(createJadwalKerjaInputBatch);
    }
    createWorkSchedule(createJadwalKerjaInput) {
        return this._jadwalKerjaService.doCreate(createJadwalKerjaInput);
    }
    async findAll(pegawaiId) {
        let where = {};
        if (pegawaiId) {
            where = {
                ...where,
                pegawai_id: pegawaiId,
            };
        }
        return await this._jadwalKerjaService.findAll(where);
    }
    async findAllMe(user, jadwalKerjaPresensiTanggalMasuk, jadwalKerjaPresensiTanggalPulang) {
        return await this._jadwalKerjaService.workScheduleByDateAndInstancie(jadwalKerjaPresensiTanggalMasuk, jadwalKerjaPresensiTanggalPulang, null, user.user.pegawai_id);
    }
    async workScheduleByDateAndInstancie(user, jadwalKerjaPresensiTanggalMasuk, instansiId) {
        if (user.user.user_level_id === '9f341ba6-7aad-497e-8f51-6a8b5d0c2943') {
            instansiId = user.user.instansi_id;
        }
        return await this._jadwalKerjaService.workScheduleByDateAndInstancie(jadwalKerjaPresensiTanggalMasuk, null, instansiId);
    }
    findOne(jadwal_kerja_id) {
        return this._jadwalKerjaService.findOne({ id: jadwal_kerja_id });
    }
    removeWorkSchedule(jadwal_kerja_id) {
        return this._jadwalKerjaService.destroy(jadwal_kerja_id);
    }
    removeWorkScheduleBatch(jadwalKerjaIds) {
        return this._jadwalKerjaService.destroyBatch(jadwalKerjaIds);
    }
    async pegawai(jadwalKerja) {
        const { pegawai_id } = jadwalKerja;
        return this._pegawaiService.findOne({ id: pegawai_id });
    }
};
exports.JadwalKerjaResolver = JadwalKerjaResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => [jadwal_kerja_entity_1.JadwalKerja], { nullable: true }),
    __param(0, (0, graphql_1.Args)('createJadwalKerjaInputBatch')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_jadwal_kerja_batch_input_1.CreateJadwalKerjaInputBatch]),
    __metadata("design:returntype", void 0)
], JadwalKerjaResolver.prototype, "createWorkScheduleBatch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => jadwal_kerja_entity_1.JadwalKerja),
    __param(0, (0, graphql_1.Args)('createJadwalKerjaInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_jadwal_kerja_input_1.CreateJadwalKerjaInput]),
    __metadata("design:returntype", void 0)
], JadwalKerjaResolver.prototype, "createWorkSchedule", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [jadwal_kerja_entity_1.JadwalKerja], { name: 'workSchedules' }),
    __param(0, (0, graphql_1.Args)('pegawai_id', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], JadwalKerjaResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.PEGAWAI),
    (0, graphql_1.Query)(() => [jadwal_kerja_entity_1.JadwalKerja], { name: 'workScheduleMe' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __param(1, (0, graphql_1.Args)('jadwalKerjaPresensiTanggalMasuk', {
        type: () => String,
        nullable: true,
    })),
    __param(2, (0, graphql_1.Args)('jadwalKerjaPresensiTanggalPulang', {
        type: () => String,
        nullable: true,
    })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], JadwalKerjaResolver.prototype, "findAllMe", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [jadwal_kerja_entity_1.JadwalKerja], { name: 'workScheduleByDateAndInstancie' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __param(1, (0, graphql_1.Args)('date', { type: () => String, nullable: true })),
    __param(2, (0, graphql_1.Args)('instansi_id', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], JadwalKerjaResolver.prototype, "workScheduleByDateAndInstancie", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => jadwal_kerja_entity_1.JadwalKerja, { name: 'workSchedule', nullable: true }),
    __param(0, (0, graphql_1.Args)('jadwal_kerja_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], JadwalKerjaResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => jadwal_kerja_entity_1.JadwalKerja),
    __param(0, (0, graphql_1.Args)('jadwal_kerja_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], JadwalKerjaResolver.prototype, "removeWorkSchedule", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => [jadwal_kerja_entity_1.JadwalKerja]),
    __param(0, (0, graphql_1.Args)('jadwalKerjaIds', { type: () => [String] })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], JadwalKerjaResolver.prototype, "removeWorkScheduleBatch", null);
__decorate([
    (0, graphql_1.ResolveField)(),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [jadwal_kerja_entity_1.JadwalKerja]),
    __metadata("design:returntype", Promise)
], JadwalKerjaResolver.prototype, "pegawai", null);
exports.JadwalKerjaResolver = JadwalKerjaResolver = __decorate([
    (0, graphql_1.Resolver)(() => jadwal_kerja_entity_1.JadwalKerja),
    __param(0, (0, common_1.Inject)('IJadwalKerjaService')),
    __param(1, (0, common_1.Inject)('IPegawaiService')),
    __metadata("design:paramtypes", [Object, Object])
], JadwalKerjaResolver);
