"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JadwalKerjaRepository = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const main_repository_1 = require("../../../core/main.repository");
let JadwalKerjaRepository = class JadwalKerjaRepository extends main_repository_1.MainRepository {
    _jadwalKerjaRepository;
    constructor(_jadwalKerjaRepository) {
        super();
        this._jadwalKerjaRepository = _jadwalKerjaRepository;
        this.datasource = this._jadwalKerjaRepository;
    }
    createBatch(jadwalKerjaList) {
        return this._jadwalKerjaRepository.save(jadwalKerjaList);
    }
    async workScheduleByDateAndInstancie(jadwalKerjaPresensiTanggalMasuk, jadwalKerjaPresensiTanggalPulang, instansiId, pegawaiId) {
        const query = this._jadwalKerjaRepository
            .createQueryBuilder('jadwal')
            .leftJoinAndSelect('jadwal.pegawai', 'pegawai');
        if (jadwalKerjaPresensiTanggalMasuk) {
            const [yearIn, monthIn, dayIn] = jadwalKerjaPresensiTanggalMasuk
                .split('-')
                .map(Number);
            if (!isNaN(yearIn)) {
                query.andWhere('EXTRACT(YEAR FROM jadwal.jadwal_kerja_presensi_tanggal_masuk) = :yearIn', { yearIn });
            }
            if (!isNaN(monthIn)) {
                query.andWhere('EXTRACT(MONTH FROM jadwal.jadwal_kerja_presensi_tanggal_masuk) = :monthIn', { monthIn });
            }
            if (!isNaN(dayIn)) {
                query.andWhere('EXTRACT(DAY FROM jadwal.jadwal_kerja_presensi_tanggal_masuk) = :dayIn', { dayIn });
            }
        }
        if (jadwalKerjaPresensiTanggalPulang) {
            const [yearOut, monthOut, dayOut] = jadwalKerjaPresensiTanggalPulang
                .split('-')
                .map(Number);
            if (!isNaN(yearOut)) {
                query.andWhere('EXTRACT(YEAR FROM jadwal.jadwal_kerja_presensi_tanggal_pulang) = :yearOut', { yearOut });
            }
            if (!isNaN(monthOut)) {
                query.andWhere('EXTRACT(MONTH FROM jadwal.jadwal_kerja_presensi_tanggal_pulang) = :monthOut', { monthOut });
            }
            if (!isNaN(dayOut)) {
                query.andWhere('EXTRACT(DAY FROM jadwal.jadwal_kerja_presensi_tanggal_pulang) = :dayOut', { dayOut });
            }
        }
        if (pegawaiId) {
            query.andWhere('jadwal.pegawai_id = :pegawaiId', { pegawaiId });
        }
        if (instansiId) {
            query.andWhere('pegawai.instansi_id = :instansiId', { instansiId });
        }
        query.orderBy('jadwal.jadwal_kerja_presensi_tanggal_masuk', 'ASC');
        return query.getMany();
    }
};
exports.JadwalKerjaRepository = JadwalKerjaRepository;
exports.JadwalKerjaRepository = JadwalKerjaRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('JADWAL_KERJA_DATASOURCE')),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], JadwalKerjaRepository);
