import { JadwalKerja } from '../entities/jadwal-kerja.entity';
import { InterfaceJadwalKerjaRepository } from '../repositories/interface.jadwal-kerja.repository';
import { InterfaceJadwalKerjaService } from './interface.jadwal-kerja.service';
import { MainService } from '../../../core/main.service';
import { CreateJadwalKerjaInput } from '../dto/create-jadwal-kerja.input';
import { InterfaceSkemaPresensiService } from '../../skema_presensi/services/interface.skema-presensi.service';
import { SkemaPresensi } from '../../skema_presensi/entities/skema-presensi.entity';
import { CreateJadwalKerjaInputBatch } from '../dto/create-jadwal-kerja-batch.input';
import { InterfacePegawaiService } from '../../pegawai/services/interface.pegawai.service';
import { Pegawai } from '../../pegawai/entities/pegawai.entity';
export declare class JadwalKerjaService extends MainService<JadwalKerja> implements InterfaceJadwalKerjaService<JadwalKerja> {
    private _jadwalKerjaRepository;
    private _skemaPresensiService;
    private _pegawaiService;
    constructor(_jadwalKerjaRepository: InterfaceJadwalKerjaRepository<JadwalKerja>, _skemaPresensiService: InterfaceSkemaPresensiService<SkemaPresensi>, _pegawaiService: InterfacePegawaiService<Pegawai>);
    doCreateBatch(data: CreateJadwalKerjaInputBatch): Promise<JadwalKerja[]>;
    workScheduleByDateAndInstancie(jadwalKerjaPresensiTanggalMasuk: null, jadwalKerjaPresensiTanggalPulang: null, instansiId: null, pegawaiId?: string | null): Promise<JadwalKerja[]>;
    _doGenerateJadwalKerja(pegawaiId: string, skemaPresensiId: string, jadwalKerjaPresensiTanggalMasuk: string): Promise<JadwalKerja>;
    doCreate(data: CreateJadwalKerjaInput): Promise<JadwalKerja>;
}
