"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JadwalKerjaService = void 0;
const common_1 = require("@nestjs/common");
const jadwal_kerja_entity_1 = require("../entities/jadwal-kerja.entity");
const main_service_1 = require("../../../core/main.service");
let JadwalKerjaService = class JadwalKerjaService extends main_service_1.MainService {
    _jadwalKerjaRepository;
    _skemaPresensiService;
    _pegawaiService;
    constructor(_jadwalKerjaRepository, _skemaPresensiService, _pegawaiService) {
        super();
        this._jadwalKerjaRepository = _jadwalKerjaRepository;
        this._skemaPresensiService = _skemaPresensiService;
        this._pegawaiService = _pegawaiService;
        this.repository = this._jadwalKerjaRepository;
    }
    async doCreateBatch(data) {
        let jadwalKerjaBatch = [];
        for (let pegawaiId of data.pegawai_ids) {
            for (let jadwalKerjaPresensiTanggalMasuk of data.jadwal_kerja_presensi_tanggal_masuk) {
                jadwalKerjaBatch.push(await this._doGenerateJadwalKerja(pegawaiId, data.skema_presensi_id, jadwalKerjaPresensiTanggalMasuk));
            }
        }
        return await this._jadwalKerjaRepository.createBatch(jadwalKerjaBatch);
    }
    async workScheduleByDateAndInstancie(jadwalKerjaPresensiTanggalMasuk, jadwalKerjaPresensiTanggalPulang, instansiId, pegawaiId) {
        return this._jadwalKerjaRepository.workScheduleByDateAndInstancie(jadwalKerjaPresensiTanggalMasuk, jadwalKerjaPresensiTanggalPulang, instansiId, pegawaiId);
    }
    async _doGenerateJadwalKerja(pegawaiId, skemaPresensiId, jadwalKerjaPresensiTanggalMasuk) {
        const skemaPresensiFind = await this._skemaPresensiService.findOne({
            id: skemaPresensiId,
        });
        if (!skemaPresensiFind)
            throw Error('Gagal, skema presensi tidak ditemukan');
        const jadwalKerja = new jadwal_kerja_entity_1.JadwalKerja();
        jadwalKerja.pegawai_id = pegawaiId;
        jadwalKerja.skema_presensi_id = skemaPresensiId;
        jadwalKerja.jadwal_kerja_jam_mulai_masuk =
            skemaPresensiFind.skema_presensi_jam_mulai_masuk;
        jadwalKerja.jadwal_kerja_jam_masuk =
            skemaPresensiFind.skema_presensi_jam_masuk;
        jadwalKerja.jadwal_kerja_jam_pulang =
            skemaPresensiFind.skema_presensi_jam_pulang;
        jadwalKerja.jadwal_kerja_jam_batas_pulang =
            skemaPresensiFind.skema_presensi_jam_batas_pulang;
        jadwalKerja.jadwal_kerja_presensi_tanggal_masuk =
            jadwalKerjaPresensiTanggalMasuk;
        jadwalKerja.jadwal_kerja_presensi_tanggal_pulang =
            jadwalKerjaPresensiTanggalMasuk;
        if (skemaPresensiFind.skema_presensi_lewat_hari) {
            const dateJadwalKerjaPresensiTanggalPulang = new Date(jadwalKerja.jadwal_kerja_presensi_tanggal_masuk);
            dateJadwalKerjaPresensiTanggalPulang.setDate(dateJadwalKerjaPresensiTanggalPulang.getDate() + 1);
            jadwalKerja.jadwal_kerja_presensi_tanggal_pulang =
                dateJadwalKerjaPresensiTanggalPulang.toISOString().split('T')[0];
        }
        jadwalKerja.jadwal_kerja_lewat_hari =
            skemaPresensiFind.skema_presensi_lewat_hari;
        const checkExistsJadwalKerja = await this.findAll({
            pegawai_id: jadwalKerja.pegawai_id,
            jadwal_kerja_presensi_tanggal_masuk: jadwalKerja.jadwal_kerja_presensi_tanggal_masuk,
        });
        if (checkExistsJadwalKerja.length > 0) {
            const pegawai = await this._pegawaiService.findOne({ id: pegawaiId });
            throw Error(`Gagal, jadwal ${pegawai?.pegawai_nama} telah diatur sebelumnya pada tanggal ${jadwalKerjaPresensiTanggalMasuk}`);
        }
        return jadwalKerja;
    }
    async doCreate(data) {
        const generateSchema = await this._doGenerateJadwalKerja(data.pegawai_id, data.skema_presensi_id, data.jadwal_kerja_presensi_tanggal_masuk);
        return this.create(generateSchema);
    }
};
exports.JadwalKerjaService = JadwalKerjaService;
exports.JadwalKerjaService = JadwalKerjaService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IJadwalKerjaRepository')),
    __param(1, (0, common_1.Inject)('ISkemaPresensiService')),
    __param(2, (0, common_1.Inject)('IPegawaiService')),
    __metadata("design:paramtypes", [Object, Object, Object])
], JadwalKerjaService);
