import { JadwalKerja } from '../jadwal_kerja/entities/jadwal-kerja.entity';
import { CreateAttendanceInput } from './dto/create-attendance.input';
import { InterfaceKehadiranService } from './services/interface.kehadiran.service';
import { IJwtPayload } from '../auth/jwt/types.jwt';
import { QrTokenResponse } from './dto/qr-token.response';
import { ValidationQrTokenResponse } from './dto/validation-qr-token.response';
import { PubSub } from 'graphql-subscriptions';
export declare class KehadiranResolver {
    private readonly _kehadiranService;
    private readonly pubSub;
    constructor(_kehadiranService: InterfaceKehadiranService, pubSub: PubSub);
    doAttendanceMe(user: IJwtPayload, createAttendanceInput: CreateAttendanceInput): Promise<JadwalKerja>;
    createQrToken(user: IJwtPayload): Promise<QrTokenResponse>;
    validateAttendanceQrToken(token: string, validUntil: string, user: IJwtPayload): Promise<ValidationQrTokenResponse>;
    qrTokenUpdated(instansi_id: string): import("graphql-subscriptions/dist/pubsub-async-iterable-iterator").PubSubAsyncIterableIterator<unknown>;
}
