"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KehadiranResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const common_1 = require("@nestjs/common");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const jadwal_kerja_entity_1 = require("../jadwal_kerja/entities/jadwal-kerja.entity");
const create_attendance_input_1 = require("./dto/create-attendance.input");
const current_user_decorator_jwt_1 = require("../auth/decorators/current-user.decorator.jwt");
const role_decorator_1 = require("../auth/decorators/role.decorator");
const constants_1 = require("../auth/constants");
const qr_token_response_1 = require("./dto/qr-token.response");
const validation_qr_token_response_1 = require("./dto/validation-qr-token.response");
const graphql_subscriptions_1 = require("graphql-subscriptions");
let KehadiranResolver = class KehadiranResolver {
    _kehadiranService;
    pubSub;
    constructor(_kehadiranService, pubSub) {
        this._kehadiranService = _kehadiranService;
        this.pubSub = pubSub;
    }
    async doAttendanceMe(user, createAttendanceInput) {
        return this._kehadiranService.doAttendanceMe(user.user.pegawai_id, createAttendanceInput);
    }
    async createQrToken(user) {
        return this._kehadiranService.generateTokenQr(user.user.instansi_id);
    }
    async validateAttendanceQrToken(token, validUntil, user) {
        const { pegawai_id } = user.user;
        return this._kehadiranService.validationTokenQr(token, validUntil, pegawai_id);
    }
    qrTokenUpdated(instansi_id) {
        return this.pubSub.asyncIterableIterator('qrTokenUpdated');
    }
};
exports.KehadiranResolver = KehadiranResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.PEGAWAI),
    (0, graphql_1.Mutation)(() => jadwal_kerja_entity_1.JadwalKerja, { name: 'createAttendanceMe' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __param(1, (0, graphql_1.Args)('createAttendanceInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, create_attendance_input_1.CreateAttendanceInput]),
    __metadata("design:returntype", Promise)
], KehadiranResolver.prototype, "doAttendanceMe", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.QR),
    (0, graphql_1.Mutation)(() => qr_token_response_1.QrTokenResponse, { name: 'createAttendanceQrToken' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], KehadiranResolver.prototype, "createQrToken", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.PEGAWAI),
    (0, graphql_1.Mutation)(() => validation_qr_token_response_1.ValidationQrTokenResponse, { name: 'validationQrToken' }),
    __param(0, (0, graphql_1.Args)('token', { type: () => String })),
    __param(1, (0, graphql_1.Args)('valid_until', { type: () => String })),
    __param(2, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Object]),
    __metadata("design:returntype", Promise)
], KehadiranResolver.prototype, "validateAttendanceQrToken", null);
__decorate([
    (0, graphql_1.Subscription)(() => qr_token_response_1.QrTokenResponse, {
        name: 'qrTokenUpdated',
        filter: (payload, variables) => payload.qrTokenUpdated.instansi_id === variables.instansi_id,
    }),
    __param(0, (0, graphql_1.Args)('instansi_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], KehadiranResolver.prototype, "qrTokenUpdated", null);
exports.KehadiranResolver = KehadiranResolver = __decorate([
    (0, graphql_1.Resolver)(() => { }),
    __param(0, (0, common_1.Inject)('IKehadiranService')),
    __param(1, (0, common_1.Inject)('PUB_SUB')),
    __metadata("design:paramtypes", [Object, graphql_subscriptions_1.PubSub])
], KehadiranResolver);
