import { InterfaceKehadiranService } from './interface.kehadiran.service';
import { CreateAttendanceInput } from '../dto/create-attendance.input';
import { InterfaceJadwalKerjaService } from '../../jadwal_kerja/services/interface.jadwal-kerja.service';
import { JadwalKerja } from '../../jadwal_kerja/entities/jadwal-kerja.entity';
import { InterfaceRiwayatPresensiService } from '../../riwayat_presensi/services/interface_riwayat_presensi_service';
import { RiwayatPresensi } from '../../riwayat_presensi/entities/riwayat_presensi.entity';
import { InterfaceInstansiService } from '../../instansi/services/interface.instansi.service';
import { Instansi } from '../../instansi/entities/instansi.entity';
import { QrTokenResponse } from '../dto/qr-token.response';
import { ValidationQrTokenResponse } from '../dto/validation-qr-token.response';
import { PubSub } from 'graphql-subscriptions';
import { InterfaceMapPegawaiLokasiPresensiService } from '../../map_pegawai_lokasi_presensi/services/interface.map-pegawai-lokasi-presensi.service';
import { MapPegawaiLokasiPresensi } from '../../map_pegawai_lokasi_presensi/entities/map-pegawai-lokasi-presensi.entity';
export declare class KehadiranService implements InterfaceKehadiranService {
    private readonly _jadwalKerjaService;
    private readonly _riwayatPresensiService;
    private readonly _instansiService;
    private readonly _mapPegawaiLokasiPresensiService;
    private readonly pubSub;
    constructor(_jadwalKerjaService: InterfaceJadwalKerjaService<JadwalKerja>, _riwayatPresensiService: InterfaceRiwayatPresensiService<RiwayatPresensi>, _instansiService: InterfaceInstansiService<Instansi>, _mapPegawaiLokasiPresensiService: InterfaceMapPegawaiLokasiPresensiService<MapPegawaiLokasiPresensi>, pubSub: PubSub);
    validationTokenQr(token: string, validUntil: string, pegawaiId: string): Promise<ValidationQrTokenResponse>;
    generateTokenQr(instansiId: string): Promise<QrTokenResponse>;
    doAttendanceMe(pegawaiId: string, input: CreateAttendanceInput, skipRiwayatCreate?: boolean): Promise<JadwalKerja>;
}
