"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KehadiranService = void 0;
const common_1 = require("@nestjs/common");
const uuid_1 = require("uuid");
const graphql_subscriptions_1 = require("graphql-subscriptions");
const global_helpers_1 = require("../../../core/helpers/global.helpers");
const time_1 = require("../../../core/helpers/time");
let KehadiranService = class KehadiranService {
    _jadwalKerjaService;
    _riwayatPresensiService;
    _instansiService;
    _mapPegawaiLokasiPresensiService;
    pubSub;
    constructor(_jadwalKerjaService, _riwayatPresensiService, _instansiService, _mapPegawaiLokasiPresensiService, pubSub) {
        this._jadwalKerjaService = _jadwalKerjaService;
        this._riwayatPresensiService = _riwayatPresensiService;
        this._instansiService = _instansiService;
        this._mapPegawaiLokasiPresensiService = _mapPegawaiLokasiPresensiService;
        this.pubSub = pubSub;
    }
    async validationTokenQr(token, validUntil, pegawaiId) {
        if (await (0, global_helpers_1.isTimeExpired)(validUntil)) {
            throw new common_1.BadRequestException('QR code telah kedaluwarsa atau format tidak valid.');
        }
        const lokasiRelasi = await this._mapPegawaiLokasiPresensiService
            .mainRepositories()
            .mainDatasource()
            .find({
            select: ['lokasi_presensi_id'],
            where: { pegawai_id: pegawaiId },
            relations: {
                lokasi_presensi: true,
            },
        });
        if (!lokasiRelasi?.length) {
            throw new common_1.NotFoundException('Lokasi presensi tidak ditemukan untuk pegawai ini.');
        }
        const uniqueInstansiIds = [
            ...new Set(lokasiRelasi.map((lok) => lok.lokasi_presensi.instansi_id)),
        ];
        const instansiFromQr = await this._instansiService.findOne({
            instansi_qr_token: token,
        });
        if (!instansiFromQr) {
            throw new common_1.NotFoundException('QR tidak valid.');
        }
        if (!uniqueInstansiIds.includes(instansiFromQr.id)) {
            throw new common_1.BadRequestException('Token QR tidak sesuai dengan akses presensi pegawai.');
        }
        const generateToken = await this.generateTokenQr(instansiFromQr.id);
        await this.pubSub.publish('qrTokenUpdated', {
            qrTokenUpdated: generateToken,
        });
        return {
            status: true,
        };
    }
    async generateTokenQr(instansiId) {
        const instansi = await this._instansiService.findOne({ id: instansiId });
        if (!instansi) {
            throw new common_1.NotFoundException('Instansi tidak ditemukan');
        }
        const token = (0, uuid_1.v4)();
        instansi.instansi_qr_token = token;
        await this._instansiService.update(instansiId, instansi);
        return {
            token,
            instansi_id: instansi.id,
        };
    }
    async doAttendanceMe(pegawaiId, input, skipRiwayatCreate = false) {
        const now = (0, time_1.getCurrentTime)();
        const jadwal_kerja_presensi_tanggal = input.jadwal_kerja_presensi_tanggal ?? now.toISODate();
        const jadwal_kerja_presensi_jam = input.jadwal_kerja_presensi_jam ?? now.toFormat('HH:mm:ss');
        const jadwal_kerja_presensi_status = input.jadwal_kerja_presensi_status;
        if (!skipRiwayatCreate) {
            await this._riwayatPresensiService.doCreate({
                pegawai_id: pegawaiId,
                riwayat_presensi_jam: jadwal_kerja_presensi_jam,
                riwayat_presensi_status: jadwal_kerja_presensi_status,
                riwayat_presensi_tanggal: jadwal_kerja_presensi_tanggal,
            });
        }
        let workSchedule;
        const queryBuilder = this._jadwalKerjaService
            .mainRepositories()
            .mainDatasource()
            .createQueryBuilder()
            .where('pegawai_id = :pegawaiId', { pegawaiId });
        if (jadwal_kerja_presensi_status === 'in') {
            workSchedule = await queryBuilder
                .andWhere('jadwal_kerja_presensi_tanggal_masuk = :tanggal', {
                tanggal: jadwal_kerja_presensi_tanggal,
            })
                .andWhere(':jam_presensi BETWEEN jadwal_kerja_jam_mulai_masuk AND jadwal_kerja_jam_masuk', { jam_presensi: jadwal_kerja_presensi_jam })
                .getOne();
            if (!workSchedule) {
                workSchedule = await this._jadwalKerjaService
                    .mainRepositories()
                    .mainDatasource()
                    .createQueryBuilder()
                    .where('pegawai_id = :pegawaiId', { pegawaiId })
                    .andWhere('jadwal_kerja_presensi_tanggal_masuk = :tanggal', {
                    tanggal: jadwal_kerja_presensi_tanggal,
                })
                    .andWhere(':jam_presensi > jadwal_kerja_jam_masuk AND :jam_presensi < jadwal_kerja_jam_pulang', { jam_presensi: jadwal_kerja_presensi_jam })
                    .getOne();
            }
        }
        else if (jadwal_kerja_presensi_status === 'out') {
            workSchedule = await queryBuilder
                .andWhere('jadwal_kerja_presensi_tanggal_pulang = :tanggal', {
                tanggal: jadwal_kerja_presensi_tanggal,
            })
                .andWhere(':jam_presensi BETWEEN jadwal_kerja_jam_pulang AND jadwal_kerja_jam_batas_pulang', { jam_presensi: jadwal_kerja_presensi_jam })
                .getOne();
        }
        else {
            throw new common_1.BadRequestException('Status presensi tidak valid');
        }
        if (!workSchedule) {
            throw new common_1.BadRequestException(`Jadwal kerja ${jadwal_kerja_presensi_status === 'in' ? 'masuk' : 'pulang'} tidak ditemukan.`);
        }
        if (jadwal_kerja_presensi_status === 'in') {
            if (workSchedule.jadwal_kerja_presensi_jam_masuk) {
                throw new common_1.BadRequestException(`Presensi masuk sudah dicatat pada jam ${workSchedule.jadwal_kerja_presensi_jam_masuk}`);
            }
            workSchedule.jadwal_kerja_presensi_jam_masuk = jadwal_kerja_presensi_jam;
            const scheduledTime = new Date(`1970-01-01T${workSchedule.jadwal_kerja_jam_masuk}`);
            const actualTime = new Date(`1970-01-01T${jadwal_kerja_presensi_jam}`);
            if (actualTime > scheduledTime) {
                const diffMs = actualTime.getTime() - scheduledTime.getTime();
                const hours = Math.floor(diffMs / (1000 * 60 * 60));
                const minutes = Math.floor((diffMs % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((diffMs % (1000 * 60)) / 1000);
                const pad = (n) => n.toString().padStart(2, '0');
                workSchedule.jadwal_kerja_jam_masuk_terlambat = `${pad(hours)}:${pad(minutes)}:${pad(seconds)}`;
            }
            else {
                workSchedule.jadwal_kerja_jam_masuk_terlambat = '00:00:00';
            }
        }
        else {
            if (workSchedule.jadwal_kerja_presensi_jam_pulang) {
                throw new common_1.BadRequestException(`Presensi pulang sudah dicatat pada jam ${workSchedule.jadwal_kerja_presensi_jam_pulang}`);
            }
            workSchedule.jadwal_kerja_presensi_jam_pulang = jadwal_kerja_presensi_jam;
        }
        return (await this._jadwalKerjaService.update(workSchedule.id, workSchedule));
    }
};
exports.KehadiranService = KehadiranService;
exports.KehadiranService = KehadiranService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IJadwalKerjaService')),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'IRiwayatPresensiService'))),
    __param(2, (0, common_1.Inject)('IInstansiService')),
    __param(3, (0, common_1.Inject)('IMapPegawaiLokasiPresensiService')),
    __param(4, (0, common_1.Inject)('PUB_SUB')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, graphql_subscriptions_1.PubSub])
], KehadiranService);
