import { LokasiPresensi } from './entities/lokasi-presensi.entity';
import { InterfaceLokasiPresensiService } from './services/interface.lokasi-presensi.service';
import { CreateLokasiPresensiInput } from './dto/create-lokasi-presensi.input';
import { UpdateLokasiPresensiInput } from './dto/update-lokasi-presensi.input';
import { Instansi } from '../instansi/entities/instansi.entity';
import { InterfaceInstansiService } from '../instansi/services/interface.instansi.service';
import { MapPegawaiLokasiPresensi } from '../map_pegawai_lokasi_presensi/entities/map-pegawai-lokasi-presensi.entity';
import { InterfaceMapPegawaiLokasiPresensiService } from '../map_pegawai_lokasi_presensi/services/interface.map-pegawai-lokasi-presensi.service';
export declare class LokasiPresensiResolver {
    private readonly _lokasiPresensiService;
    private readonly _interfaceInstansiService;
    private readonly _mapPegawaiLokasiPresensiService;
    constructor(_lokasiPresensiService: InterfaceLokasiPresensiService<LokasiPresensi>, _interfaceInstansiService: InterfaceInstansiService<Instansi>, _mapPegawaiLokasiPresensiService: InterfaceMapPegawaiLokasiPresensiService<MapPegawaiLokasiPresensi>);
    createPresenceLocation(createLokasiPresensiInput: CreateLokasiPresensiInput): Promise<LokasiPresensi>;
    findAll(): Promise<LokasiPresensi[]>;
    findOne(lokasi_presensi_id: string): Promise<LokasiPresensi | null>;
    updatePresenceLocation(lokasi_presensi_id: string, updateLokasiPresensiInput: UpdateLokasiPresensiInput): Promise<LokasiPresensi | null>;
    removePresenceLocation(lokasi_presensi_id: string): Promise<LokasiPresensi | null>;
    instansi(lokasiPresensi: LokasiPresensi): Promise<Instansi | null>;
    mapPegawaiLokasiPresensi(lokasiPresensi: LokasiPresensi): Promise<MapPegawaiLokasiPresensi[]>;
}
