"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LokasiPresensiResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const lokasi_presensi_entity_1 = require("./entities/lokasi-presensi.entity");
const common_1 = require("@nestjs/common");
const create_lokasi_presensi_input_1 = require("./dto/create-lokasi-presensi.input");
const update_lokasi_presensi_input_1 = require("./dto/update-lokasi-presensi.input");
const instansi_entity_1 = require("../instansi/entities/instansi.entity");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const map_pegawai_lokasi_presensi_entity_1 = require("../map_pegawai_lokasi_presensi/entities/map-pegawai-lokasi-presensi.entity");
let LokasiPresensiResolver = class LokasiPresensiResolver {
    _lokasiPresensiService;
    _interfaceInstansiService;
    _mapPegawaiLokasiPresensiService;
    constructor(_lokasiPresensiService, _interfaceInstansiService, _mapPegawaiLokasiPresensiService) {
        this._lokasiPresensiService = _lokasiPresensiService;
        this._interfaceInstansiService = _interfaceInstansiService;
        this._mapPegawaiLokasiPresensiService = _mapPegawaiLokasiPresensiService;
    }
    async createPresenceLocation(createLokasiPresensiInput) {
        return this._lokasiPresensiService.doCreate(createLokasiPresensiInput);
    }
    async findAll() {
        return await this._lokasiPresensiService.findAll();
    }
    findOne(lokasi_presensi_id) {
        return this._lokasiPresensiService.findOne({ id: lokasi_presensi_id });
    }
    updatePresenceLocation(lokasi_presensi_id, updateLokasiPresensiInput) {
        return this._lokasiPresensiService.update(lokasi_presensi_id, updateLokasiPresensiInput);
    }
    removePresenceLocation(lokasi_presensi_id) {
        return this._lokasiPresensiService.destroy(lokasi_presensi_id);
    }
    async instansi(lokasiPresensi) {
        const { instansi_id } = lokasiPresensi;
        return this._interfaceInstansiService.findOne({ id: instansi_id });
    }
    async mapPegawaiLokasiPresensi(lokasiPresensi) {
        console.log('masuk ai');
        const { id } = lokasiPresensi;
        return this._mapPegawaiLokasiPresensiService.findAll({
            lokasi_presensi_id: id,
        });
    }
};
exports.LokasiPresensiResolver = LokasiPresensiResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => lokasi_presensi_entity_1.LokasiPresensi),
    __param(0, (0, graphql_1.Args)('createLokasiPresensiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_lokasi_presensi_input_1.CreateLokasiPresensiInput]),
    __metadata("design:returntype", Promise)
], LokasiPresensiResolver.prototype, "createPresenceLocation", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [lokasi_presensi_entity_1.LokasiPresensi], { name: 'presenceLocations' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LokasiPresensiResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => lokasi_presensi_entity_1.LokasiPresensi, { name: 'presenceLocation', nullable: true }),
    __param(0, (0, graphql_1.Args)('lokasi_presensi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], LokasiPresensiResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => lokasi_presensi_entity_1.LokasiPresensi),
    __param(0, (0, graphql_1.Args)('lokasi_presensi_id', { type: () => String })),
    __param(1, (0, graphql_1.Args)('updateLokasiPresensiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_lokasi_presensi_input_1.UpdateLokasiPresensiInput]),
    __metadata("design:returntype", void 0)
], LokasiPresensiResolver.prototype, "updatePresenceLocation", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => lokasi_presensi_entity_1.LokasiPresensi),
    __param(0, (0, graphql_1.Args)('lokasi_presensi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], LokasiPresensiResolver.prototype, "removePresenceLocation", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.ResolveField)('instansi', () => instansi_entity_1.Instansi),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [lokasi_presensi_entity_1.LokasiPresensi]),
    __metadata("design:returntype", Promise)
], LokasiPresensiResolver.prototype, "instansi", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.ResolveField)(() => [map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi], {
        name: 'map_pegawai_lokasi_presensi',
    }),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [lokasi_presensi_entity_1.LokasiPresensi]),
    __metadata("design:returntype", Promise)
], LokasiPresensiResolver.prototype, "mapPegawaiLokasiPresensi", null);
exports.LokasiPresensiResolver = LokasiPresensiResolver = __decorate([
    (0, graphql_1.Resolver)(() => lokasi_presensi_entity_1.LokasiPresensi),
    __param(0, (0, common_1.Inject)('ILokasiPresensiService')),
    __param(1, (0, common_1.Inject)('IInstansiService')),
    __param(2, (0, common_1.Inject)('IMapPegawaiLokasiPresensiService')),
    __metadata("design:paramtypes", [Object, Object, Object])
], LokasiPresensiResolver);
