"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapPegawaiLokasiPresensiResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const map_pegawai_lokasi_presensi_entity_1 = require("./entities/map-pegawai-lokasi-presensi.entity");
const common_1 = require("@nestjs/common");
const create_map_pegawai_lokasi_presensi_input_1 = require("./dto/create-map-pegawai-lokasi-presensi.input");
const lokasi_presensi_entity_1 = require("../lokasi_presensi/entities/lokasi-presensi.entity");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
let MapPegawaiLokasiPresensiResolver = class MapPegawaiLokasiPresensiResolver {
    _mapPegawaiLokasiPresensiService;
    lokasiPresensiService;
    constructor(_mapPegawaiLokasiPresensiService, lokasiPresensiService) {
        this._mapPegawaiLokasiPresensiService = _mapPegawaiLokasiPresensiService;
        this.lokasiPresensiService = lokasiPresensiService;
    }
    createMapEmployeeLocationPresence(createMapPegawaiLokasiPresensiInput) {
        return this._mapPegawaiLokasiPresensiService.doCreate(createMapPegawaiLokasiPresensiInput);
    }
    findAll(pegawaiId) {
        let where = {};
        if (pegawaiId) {
            where = {
                ...where,
                pegawai_id: pegawaiId,
            };
        }
        return this._mapPegawaiLokasiPresensiService.findAll(where);
    }
    findOne(map_pegawai_lokasi_presensi_id) {
        return this._mapPegawaiLokasiPresensiService.findOne({
            id: map_pegawai_lokasi_presensi_id,
        });
    }
    removeMapEmployeeLocationPresence(map_pegawai_lokasi_presensi_id) {
        return this._mapPegawaiLokasiPresensiService.destroy(map_pegawai_lokasi_presensi_id);
    }
    async lokasiPresensi(mapPegawaiLokasiPresensi) {
        const { lokasi_presensi_id } = mapPegawaiLokasiPresensi;
        return this.lokasiPresensiService.findOne({ id: lokasi_presensi_id });
    }
};
exports.MapPegawaiLokasiPresensiResolver = MapPegawaiLokasiPresensiResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi),
    __param(0, (0, graphql_1.Args)('createMapPegawaiLokasiPresensiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_map_pegawai_lokasi_presensi_input_1.CreateMapPegawaiLokasiPresensiInput]),
    __metadata("design:returntype", void 0)
], MapPegawaiLokasiPresensiResolver.prototype, "createMapEmployeeLocationPresence", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi], {
        name: 'mapEmployeeLocationPresences',
    }),
    __param(0, (0, graphql_1.Args)('pegawaiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MapPegawaiLokasiPresensiResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi, {
        name: 'mapEmployeeLocationPresence',
        nullable: true,
    }),
    __param(0, (0, graphql_1.Args)('map_pegawai_lokasi_presensi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MapPegawaiLokasiPresensiResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi),
    __param(0, (0, graphql_1.Args)('map_pegawai_lokasi_presensi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MapPegawaiLokasiPresensiResolver.prototype, "removeMapEmployeeLocationPresence", null);
__decorate([
    (0, graphql_1.ResolveField)('lokasi_presensi', () => lokasi_presensi_entity_1.LokasiPresensi, { nullable: true }),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi]),
    __metadata("design:returntype", Promise)
], MapPegawaiLokasiPresensiResolver.prototype, "lokasiPresensi", null);
exports.MapPegawaiLokasiPresensiResolver = MapPegawaiLokasiPresensiResolver = __decorate([
    (0, graphql_1.Resolver)(() => map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi),
    __param(0, (0, common_1.Inject)('IMapPegawaiLokasiPresensiService')),
    __param(1, (0, common_1.Inject)('ILokasiPresensiService')),
    __metadata("design:paramtypes", [Object, Object])
], MapPegawaiLokasiPresensiResolver);
