"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const menu_entity_1 = require("./entities/menu.entity");
const common_1 = require("@nestjs/common");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const current_user_decorator_jwt_1 = require("../auth/decorators/current-user.decorator.jwt");
let MenuResolver = class MenuResolver {
    _menuService;
    constructor(_menuService) {
        this._menuService = _menuService;
    }
    async findAll() {
        return await this._menuService.findAll();
    }
    async findMenuMe(user) {
        return await this._menuService.findByUserId(user.user_id);
    }
};
exports.MenuResolver = MenuResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [menu_entity_1.Menu], { name: 'menus' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MenuResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [menu_entity_1.Menu], { name: 'menuMe' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MenuResolver.prototype, "findMenuMe", null);
exports.MenuResolver = MenuResolver = __decorate([
    (0, graphql_1.Resolver)(() => menu_entity_1.Menu),
    __param(0, (0, common_1.Inject)('IMenuService')),
    __metadata("design:paramtypes", [Object])
], MenuResolver);
