"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuService = void 0;
const common_1 = require("@nestjs/common");
const main_service_1 = require("../../../core/main.service");
let MenuService = class MenuService extends main_service_1.MainService {
    _menuRepository;
    _userService;
    constructor(_menuRepository, _userService) {
        super();
        this._menuRepository = _menuRepository;
        this._userService = _userService;
        this.repository = this._menuRepository;
    }
    async findByUserId(userId) {
        const findUser = await this._userService.findOne({ id: userId });
        if (!findUser) {
            throw Error('User not found');
        }
        return this._menuRepository
            .mainDatasource()
            .createQueryBuilder('menu')
            .innerJoin('menu.menu_manage', 'menu_manage')
            .where('menu_manage.user_level_id = :userLevelId', {
            userLevelId: findUser.user_level_id,
        })
            .orderBy('menu_order', 'ASC')
            .getMany();
    }
};
exports.MenuService = MenuService;
exports.MenuService = MenuService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IMenuRepository')),
    __param(1, (0, common_1.Inject)('IUserService')),
    __metadata("design:paramtypes", [Object, Object])
], MenuService);
