"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pegawai = void 0;
const graphql_1 = require("@nestjs/graphql");
const typeorm_1 = require("typeorm");
const instansi_entity_1 = require("../../instansi/entities/instansi.entity");
const map_pegawai_lokasi_presensi_entity_1 = require("../../map_pegawai_lokasi_presensi/entities/map-pegawai-lokasi-presensi.entity");
const jadwal_kerja_entity_1 = require("../../jadwal_kerja/entities/jadwal-kerja.entity");
const riwayat_presensi_entity_1 = require("../../riwayat_presensi/entities/riwayat_presensi.entity");
const user_entity_1 = require("../../user/entities/user.entity");
let Pegawai = class Pegawai {
    id;
    instansi_id;
    pegawai_nip;
    pegawai_nama;
    created_at;
    updated_at;
    instansi;
    map_pegawai_lokasi_presensi;
    jadwal_kerja;
    riwayat_presensi;
    user;
};
exports.Pegawai = Pegawai;
__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', {
        generated: 'uuid',
        name: 'pegawai_id',
    }),
    (0, graphql_1.Field)(() => graphql_1.ID, {
        name: 'pegawai_id',
    }),
    __metadata("design:type", String)
], Pegawai.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    (0, graphql_1.Field)(() => String, { nullable: true }),
    __metadata("design:type", String)
], Pegawai.prototype, "instansi_id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, graphql_1.Field)(() => String),
    __metadata("design:type", String)
], Pegawai.prototype, "pegawai_nip", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, graphql_1.Field)(() => String),
    __metadata("design:type", String)
], Pegawai.prototype, "pegawai_nama", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ type: 'timestamp without time zone' }),
    (0, graphql_1.Field)(() => Date),
    __metadata("design:type", Date)
], Pegawai.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({ type: 'timestamp without time zone', nullable: true }),
    (0, graphql_1.Field)(() => Date, { nullable: true }),
    __metadata("design:type", Date)
], Pegawai.prototype, "updated_at", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => instansi_entity_1.Instansi, (instansi) => instansi.pegawai),
    (0, typeorm_1.JoinColumn)({
        name: 'instansi_id',
        referencedColumnName: 'id',
    }),
    (0, graphql_1.Field)(() => instansi_entity_1.Instansi, { nullable: true }),
    __metadata("design:type", instansi_entity_1.Instansi)
], Pegawai.prototype, "instansi", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi, (mapPegawaiLokasiPresensi) => mapPegawaiLokasiPresensi.pegawai),
    (0, graphql_1.Field)(() => [map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi]),
    __metadata("design:type", Array)
], Pegawai.prototype, "map_pegawai_lokasi_presensi", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => jadwal_kerja_entity_1.JadwalKerja, (jadwalKerja) => jadwalKerja.pegawai),
    (0, typeorm_1.JoinColumn)({
        name: 'id',
        referencedColumnName: 'pegawai_id',
    }),
    (0, graphql_1.Field)(() => [jadwal_kerja_entity_1.JadwalKerja], { nullable: true }),
    __metadata("design:type", Array)
], Pegawai.prototype, "jadwal_kerja", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => riwayat_presensi_entity_1.RiwayatPresensi, (riwayatPresensi) => riwayatPresensi.pegawai),
    (0, typeorm_1.JoinColumn)({
        name: 'id',
        referencedColumnName: 'pegawai_id',
    }),
    (0, graphql_1.Field)(() => [riwayat_presensi_entity_1.RiwayatPresensi]),
    __metadata("design:type", Array)
], Pegawai.prototype, "riwayat_presensi", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => user_entity_1.User, (user) => user.pegawai, { nullable: true }),
    (0, typeorm_1.JoinColumn)({
        name: 'pegawai_id',
        referencedColumnName: 'id',
    }),
    (0, graphql_1.Field)(() => user_entity_1.User, { nullable: true }),
    __metadata("design:type", user_entity_1.User)
], Pegawai.prototype, "user", void 0);
exports.Pegawai = Pegawai = __decorate([
    (0, typeorm_1.Entity)('tb_pegawai'),
    (0, typeorm_1.Unique)(['pegawai_nip']),
    (0, graphql_1.ObjectType)()
], Pegawai);
