"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PegawaiModule = void 0;
const common_1 = require("@nestjs/common");
const pegawai_service_1 = require("./services/pegawai.service");
const pegawai_resolver_1 = require("./pegawai.resolver");
const database_module_1 = require("../../core/database/database.module");
const pegawai_provider_datasource_1 = require("./providers/pegawai.provider.datasource");
const pegawai_repository_1 = require("./repositories/pegawai.repository");
const map_pegawai_lokasi_presensi_module_1 = require("../map_pegawai_lokasi_presensi/map-pegawai-lokasi-presensi.module");
const instansi_module_1 = require("../instansi/instansi.module");
const jadwal_kerja_module_1 = require("../jadwal_kerja/jadwal-kerja.module");
const user_module_1 = require("../user/user.module");
let PegawaiModule = class PegawaiModule {
};
exports.PegawaiModule = PegawaiModule;
exports.PegawaiModule = PegawaiModule = __decorate([
    (0, common_1.Module)({
        imports: [
            database_module_1.DatabaseModule,
            map_pegawai_lokasi_presensi_module_1.MapPegawaiLokasiPresensiModule,
            instansi_module_1.InstansiModule,
            (0, common_1.forwardRef)(() => jadwal_kerja_module_1.JadwalKerjaModule),
            (0, common_1.forwardRef)(() => user_module_1.UserModule),
        ],
        providers: [
            pegawai_resolver_1.PegawaiResolver,
            ...pegawai_provider_datasource_1.pegawaiProviderDatasource,
            {
                provide: 'IPegawaiService',
                useClass: pegawai_service_1.PegawaiService,
            },
            {
                provide: 'IPegawaiRepository',
                useClass: pegawai_repository_1.PegawaiRepository,
            },
        ],
        exports: [
            {
                provide: 'IPegawaiService',
                useClass: pegawai_service_1.PegawaiService,
            },
        ],
    })
], PegawaiModule);
