import { Pegawai } from './entities/pegawai.entity';
import { InterfacePegawaiService } from './services/interface.pegawai.service';
import { CreatePegawaiInput } from './dto/create-pegawai.input';
import { UpdatePegawaiInput } from './dto/update-pegawai.input';
import { PegawaiPagination } from './entities/pegawai-pagination.entity';
import { IJwtPayload } from '../auth/jwt/types.jwt';
import { Instansi } from '../instansi/entities/instansi.entity';
import { InterfaceInstansiService } from '../instansi/services/interface.instansi.service';
import { InterfaceJadwalKerjaService } from '../jadwal_kerja/services/interface.jadwal-kerja.service';
import { JadwalKerja } from '../jadwal_kerja/entities/jadwal-kerja.entity';
import { MapPegawaiLokasiPresensi } from '../map_pegawai_lokasi_presensi/entities/map-pegawai-lokasi-presensi.entity';
import { InterfaceMapPegawaiLokasiPresensiService } from '../map_pegawai_lokasi_presensi/services/interface.map-pegawai-lokasi-presensi.service';
import { User } from '../user/entities/user.entity';
import { InterfaceUserService } from '../user/services/interface.user.service';
export declare class PegawaiResolver {
    private readonly _pegawaiService;
    private readonly _instansiService;
    private readonly _jadwalKerjaService;
    private readonly _mapPegawaiLokasiPresensiService;
    private readonly _userService;
    constructor(_pegawaiService: InterfacePegawaiService<Pegawai>, _instansiService: InterfaceInstansiService<Instansi>, _jadwalKerjaService: InterfaceJadwalKerjaService<JadwalKerja>, _mapPegawaiLokasiPresensiService: InterfaceMapPegawaiLokasiPresensiService<MapPegawaiLokasiPresensi>, _userService: InterfaceUserService<User>);
    createEmployee(createPegawaiInput: CreatePegawaiInput): Promise<Pegawai>;
    findAll(instansiId?: string): Promise<Pegawai[]>;
    findAllWithWorkSchedule(user: IJwtPayload, date: string, instansiId?: string | null): Promise<Pegawai[]>;
    findAllWithWorkScheduleMonthYear(user: IJwtPayload, month: string, year: string, instansiId: string): Promise<Pegawai[]>;
    findOne(pegawai_id: string): Promise<Pegawai | null>;
    updateEmployee(pegawai_id: string, updatePegawaiInput: UpdatePegawaiInput): Promise<Pegawai | null>;
    removeEmployee(pegawai_id: string): Promise<Pegawai | null>;
    employeePagination(perPage: number, page: number, search?: string, instansiId?: string): Promise<PegawaiPagination>;
    searchByNipOrName(keyword: string, instansiId?: string): Promise<Pegawai[]>;
    instansi(pegawai: Pegawai): Promise<Instansi | null>;
    mapPegawaiLokasiPresensi(pegawai: Pegawai): Promise<MapPegawaiLokasiPresensi[]>;
    user(pegawai: Pegawai): Promise<User | null>;
}
