"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PegawaiResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const pegawai_entity_1 = require("./entities/pegawai.entity");
const common_1 = require("@nestjs/common");
const create_pegawai_input_1 = require("./dto/create-pegawai.input");
const update_pegawai_input_1 = require("./dto/update-pegawai.input");
const pegawai_pagination_entity_1 = require("./entities/pegawai-pagination.entity");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const current_user_decorator_jwt_1 = require("../auth/decorators/current-user.decorator.jwt");
const instansi_entity_1 = require("../instansi/entities/instansi.entity");
const map_pegawai_lokasi_presensi_entity_1 = require("../map_pegawai_lokasi_presensi/entities/map-pegawai-lokasi-presensi.entity");
const user_entity_1 = require("../user/entities/user.entity");
const role_decorator_1 = require("../auth/decorators/role.decorator");
const constants_1 = require("../auth/constants");
let PegawaiResolver = class PegawaiResolver {
    _pegawaiService;
    _instansiService;
    _jadwalKerjaService;
    _mapPegawaiLokasiPresensiService;
    _userService;
    constructor(_pegawaiService, _instansiService, _jadwalKerjaService, _mapPegawaiLokasiPresensiService, _userService) {
        this._pegawaiService = _pegawaiService;
        this._instansiService = _instansiService;
        this._jadwalKerjaService = _jadwalKerjaService;
        this._mapPegawaiLokasiPresensiService = _mapPegawaiLokasiPresensiService;
        this._userService = _userService;
    }
    createEmployee(createPegawaiInput) {
        return this._pegawaiService.doCreate(createPegawaiInput);
    }
    findAll(instansiId) {
        let where = {};
        if (instansiId) {
            where = {
                ...where,
                instansi_id: instansiId,
            };
        }
        return this._pegawaiService.findAll(where);
    }
    findAllWithWorkSchedule(user, date, instansiId) {
        if (user.user.user_level_id === '9f341ba6-7aad-497e-8f51-6a8b5d0c2943') {
            instansiId = user.user.instansi_id;
        }
        return this._pegawaiService.findAllWithWorkSchedule(date, instansiId);
    }
    findAllWithWorkScheduleMonthYear(user, month, year, instansiId) {
        if (user.user.user_level_id === '9f341ba6-7aad-497e-8f51-6a8b5d0c2943') {
            instansiId = user.user.instansi_id;
        }
        return this._pegawaiService.findAllWithWorkScheduleMonthYear(month, year, instansiId);
    }
    findOne(pegawai_id) {
        return this._pegawaiService.findOne({ id: pegawai_id });
    }
    updateEmployee(pegawai_id, updatePegawaiInput) {
        return this._pegawaiService.update(pegawai_id, updatePegawaiInput);
    }
    async removeEmployee(pegawai_id) {
        return this._pegawaiService.destroy(pegawai_id);
    }
    async employeePagination(perPage, page, search, instansiId) {
        const [data, totalCount] = await this._pegawaiService.findAllWithPagination(perPage, page, instansiId, search);
        return { totalCount, data };
    }
    async searchByNipOrName(keyword, instansiId) {
        return this._pegawaiService.findByNipOrName(keyword, instansiId);
    }
    async instansi(pegawai) {
        const { instansi_id: id } = pegawai;
        return this._instansiService.findOne({ id });
    }
    async mapPegawaiLokasiPresensi(pegawai) {
        const { id } = pegawai;
        return this._mapPegawaiLokasiPresensiService.findAll({
            pegawai_id: id,
        });
    }
    async user(pegawai) {
        const { id } = pegawai;
        return this._userService.findOne({
            pegawai_id: id,
        });
    }
};
exports.PegawaiResolver = PegawaiResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => pegawai_entity_1.Pegawai),
    __param(0, (0, graphql_1.Args)('createPegawaiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_pegawai_input_1.CreatePegawaiInput]),
    __metadata("design:returntype", void 0)
], PegawaiResolver.prototype, "createEmployee", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [pegawai_entity_1.Pegawai], { name: 'employees' }),
    __param(0, (0, graphql_1.Args)('instansiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PegawaiResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Query)(() => [pegawai_entity_1.Pegawai], { name: 'employeesWithWorkSchedule' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __param(1, (0, graphql_1.Args)('date', { type: () => String })),
    __param(2, (0, graphql_1.Args)('instansiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, Object]),
    __metadata("design:returntype", void 0)
], PegawaiResolver.prototype, "findAllWithWorkSchedule", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Query)(() => [pegawai_entity_1.Pegawai], { name: 'employeesWithWorkScheduleMonthYear' }),
    __param(0, (0, current_user_decorator_jwt_1.CurrentUser)()),
    __param(1, (0, graphql_1.Args)('month', { type: () => String })),
    __param(2, (0, graphql_1.Args)('year', { type: () => String })),
    __param(3, (0, graphql_1.Args)('instansiId', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, String, String]),
    __metadata("design:returntype", void 0)
], PegawaiResolver.prototype, "findAllWithWorkScheduleMonthYear", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => pegawai_entity_1.Pegawai, { name: 'employee', nullable: true }),
    __param(0, (0, graphql_1.Args)('pegawai_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PegawaiResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => pegawai_entity_1.Pegawai),
    __param(0, (0, graphql_1.Args)('pegawai_id', { type: () => String })),
    __param(1, (0, graphql_1.Args)('updatePegawaiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_pegawai_input_1.UpdatePegawaiInput]),
    __metadata("design:returntype", void 0)
], PegawaiResolver.prototype, "updateEmployee", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => pegawai_entity_1.Pegawai),
    __param(0, (0, graphql_1.Args)('pegawai_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PegawaiResolver.prototype, "removeEmployee", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => pegawai_pagination_entity_1.PegawaiPagination),
    __param(0, (0, graphql_1.Args)('perPage', { type: () => graphql_1.Int, defaultValue: 10 })),
    __param(1, (0, graphql_1.Args)('page', { type: () => graphql_1.Int, defaultValue: 0 })),
    __param(2, (0, graphql_1.Args)('search', { type: () => String, nullable: true })),
    __param(3, (0, graphql_1.Args)('instansiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], PegawaiResolver.prototype, "employeePagination", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [pegawai_entity_1.Pegawai], { name: 'employeesSearch' }),
    __param(0, (0, graphql_1.Args)('keyword', { type: () => String })),
    __param(1, (0, graphql_1.Args)('instansiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], PegawaiResolver.prototype, "searchByNipOrName", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.ResolveField)(() => instansi_entity_1.Instansi, { name: 'instansi' }),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pegawai_entity_1.Pegawai]),
    __metadata("design:returntype", Promise)
], PegawaiResolver.prototype, "instansi", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.ResolveField)(() => [map_pegawai_lokasi_presensi_entity_1.MapPegawaiLokasiPresensi], {
        name: 'map_pegawai_lokasi_presensi',
    }),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pegawai_entity_1.Pegawai]),
    __metadata("design:returntype", Promise)
], PegawaiResolver.prototype, "mapPegawaiLokasiPresensi", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.ResolveField)(() => user_entity_1.User, {
        name: 'user',
        nullable: true,
    }),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pegawai_entity_1.Pegawai]),
    __metadata("design:returntype", Promise)
], PegawaiResolver.prototype, "user", null);
exports.PegawaiResolver = PegawaiResolver = __decorate([
    (0, graphql_1.Resolver)(() => pegawai_entity_1.Pegawai),
    __param(0, (0, common_1.Inject)('IPegawaiService')),
    __param(1, (0, common_1.Inject)('IInstansiService')),
    __param(2, (0, common_1.Inject)('IJadwalKerjaService')),
    __param(3, (0, common_1.Inject)('IMapPegawaiLokasiPresensiService')),
    __param(4, (0, common_1.Inject)('IUserService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object])
], PegawaiResolver);
