import { Repository } from 'typeorm';
import { MainRepository } from '../../../core/main.repository';
import { InterfacePegawaiRepository } from './interface.pegawai.repository';
import { Pegawai } from '../entities/pegawai.entity';
export declare class PegawaiRepository extends MainRepository<Pegawai> implements InterfacePegawaiRepository<Pegawai> {
    private _pegawaiRepository;
    constructor(_pegawaiRepository: Repository<Pegawai>);
    findAllWithWorkScheduleMonthYear(month: string, year: string, instansiId?: string): Promise<Pegawai[]>;
    findAllWithWorkSchedule(date: string, instansiId?: string): Promise<Pegawai[]>;
    findAllWithPagination(perPage: number, page: number, instansiId?: string | null, search?: string | null): Promise<[Pegawai[], number]>;
    findByNipOrName(keyword: string, instansiId?: string): Promise<Pegawai[]>;
}
