"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PegawaiRepository = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const main_repository_1 = require("../../../core/main.repository");
let PegawaiRepository = class PegawaiRepository extends main_repository_1.MainRepository {
    _pegawaiRepository;
    constructor(_pegawaiRepository) {
        super();
        this._pegawaiRepository = _pegawaiRepository;
        this.datasource = this._pegawaiRepository;
    }
    async findAllWithWorkScheduleMonthYear(month, year, instansiId) {
        const qb = this.datasource
            .createQueryBuilder('pegawai')
            .leftJoinAndSelect('pegawai.jadwal_kerja', 'jadwal_kerja', `TO_CHAR(jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk, 'YYYY-MM') = :yearMonth`, {
            yearMonth: `${year}-${month.padStart(2, '0')}`,
        })
            .leftJoinAndSelect('pegawai.instansi', 'instansi')
            .select([
            'pegawai.id',
            'pegawai.pegawai_nip',
            'pegawai.pegawai_nama',
            'pegawai.instansi_id',
            'instansi.id',
            'instansi.instansi_nama',
            'jadwal_kerja.id',
            'jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk',
            'jadwal_kerja.jadwal_kerja_jam_mulai_masuk',
            'jadwal_kerja.jadwal_kerja_jam_masuk',
            'jadwal_kerja.jadwal_kerja_presensi_tanggal_pulang',
            'jadwal_kerja.jadwal_kerja_jam_pulang',
            'jadwal_kerja.jadwal_kerja_jam_batas_pulang',
            'jadwal_kerja.jadwal_kerja_presensi_jam_masuk',
            'jadwal_kerja.jadwal_kerja_presensi_jam_pulang',
            'jadwal_kerja.jadwal_kerja_lewat_hari',
            'jadwal_kerja.jadwal_kerja_jam_masuk_terlambat',
            'jadwal_kerja.pegawai_id',
            'jadwal_kerja.skema_presensi_id',
        ])
            .orderBy('pegawai.pegawai_nama', 'ASC')
            .addOrderBy('jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk', 'ASC');
        if (instansiId) {
            qb.andWhere('pegawai.instansi_id = :instansiId', { instansiId });
        }
        return await qb.getMany();
    }
    async findAllWithWorkSchedule(date, instansiId) {
        const qb = this.datasource
            .createQueryBuilder('pegawai')
            .leftJoinAndSelect('pegawai.instansi', 'instansi')
            .leftJoinAndSelect('pegawai.jadwal_kerja', 'jadwal_kerja', 'jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk = :tanggal', { tanggal: date })
            .select([
            'pegawai.id',
            'pegawai.pegawai_nip',
            'pegawai.pegawai_nama',
            'pegawai.instansi_id',
            'instansi.id',
            'instansi.instansi_nama',
            'jadwal_kerja.id',
            'jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk',
            'jadwal_kerja.jadwal_kerja_jam_mulai_masuk',
            'jadwal_kerja.jadwal_kerja_jam_masuk',
            'jadwal_kerja.jadwal_kerja_presensi_tanggal_pulang',
            'jadwal_kerja.jadwal_kerja_jam_pulang',
            'jadwal_kerja.jadwal_kerja_jam_batas_pulang',
            'jadwal_kerja.jadwal_kerja_presensi_jam_masuk',
            'jadwal_kerja.jadwal_kerja_presensi_jam_pulang',
            'jadwal_kerja.jadwal_kerja_lewat_hari',
            'jadwal_kerja.jadwal_kerja_jam_masuk_terlambat',
            'jadwal_kerja.pegawai_id',
            'jadwal_kerja.skema_presensi_id',
        ])
            .orderBy('pegawai.pegawai_nama', 'ASC')
            .addOrderBy('jadwal_kerja.jadwal_kerja_presensi_tanggal_masuk', 'ASC');
        if (instansiId) {
            qb.andWhere('pegawai.instansi_id = :instansiId', { instansiId });
        }
        const asd = await qb.getMany();
        console.log(asd);
        return asd;
    }
    async findAllWithPagination(perPage, page, instansiId = null, search = null) {
        const qb = this.datasource
            .createQueryBuilder('pegawai')
            .leftJoinAndSelect('pegawai.instansi', 'instansi')
            .leftJoinAndSelect('pegawai.map_pegawai_lokasi_presensi', 'map_pegawai_lokasi_presensi')
            .select([
            'pegawai.id',
            'pegawai.pegawai_nip',
            'pegawai.pegawai_nama',
            'pegawai.created_at',
            'pegawai.updated_at',
            'pegawai.instansi_id',
            'instansi.id',
            'instansi.instansi_nama',
            'map_pegawai_lokasi_presensi.id',
            'map_pegawai_lokasi_presensi.pegawai_id',
            'map_pegawai_lokasi_presensi.lokasi_presensi_id',
        ])
            .orderBy('instansi.instansi_nama', 'ASC')
            .orderBy('pegawai.pegawai_nama', 'ASC')
            .skip((page - 1) * perPage)
            .take(perPage);
        if (instansiId) {
            qb.andWhere('pegawai.instansi_id = :instansiId', { instansiId });
        }
        if (search) {
            qb.andWhere(`(LOWER(pegawai.pegawai_nama) LIKE LOWER(:search) OR LOWER(pegawai.pegawai_nip) LIKE LOWER(:search))`, { search: `%${search}%` });
        }
        const [data, total] = await qb.getManyAndCount();
        return [data, total];
    }
    async findByNipOrName(keyword, instansiId) {
        const qb = this.datasource
            .createQueryBuilder('pegawai')
            .leftJoinAndSelect('pegawai.instansi', 'instansi')
            .select([
            'pegawai.id',
            'pegawai.pegawai_nip',
            'pegawai.pegawai_nama',
            'pegawai.instansi_id',
            'instansi.id',
            'instansi.instansi_nama',
        ])
            .where(`(LOWER(pegawai.pegawai_nama) LIKE LOWER(:keyword) OR LOWER(pegawai.pegawai_nip) LIKE LOWER(:keyword))`, { keyword: `%${keyword}%` })
            .orderBy('pegawai.pegawai_nama', 'ASC');
        if (instansiId) {
            qb.andWhere('pegawai.instansi_id = :instansiId', { instansiId });
        }
        return await qb.getMany();
    }
};
exports.PegawaiRepository = PegawaiRepository;
exports.PegawaiRepository = PegawaiRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('PEGAWAI_DATASOURCE')),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], PegawaiRepository);
