import InterfaceMainService from '../../../core/interface.main.service';
import { CreatePegawaiInput } from '../dto/create-pegawai.input';
import { ObjectLiteral } from 'typeorm';
export interface InterfacePegawaiService<T extends ObjectLiteral> extends InterfaceMainService<T> {
    doCreate(data: CreatePegawaiInput): Promise<T>;
    findAllWithPagination(perPage: number, page: number, instansiId?: string, search?: string): Promise<[T[], number]>;
    findAllWithWorkSchedule(date: string, instansiId?: string | null): Promise<T[]>;
    findAllWithWorkScheduleMonthYear(month: string, year: string, instansiId?: string | null): Promise<T[]>;
    findByNipOrName(keyword: string, instansiId?: string): Promise<T[]>;
}
