import { Pegawai } from '../entities/pegawai.entity';
import { InterfacePegawaiRepository } from '../repositories/interface.pegawai.repository';
import { InterfacePegawaiService } from './interface.pegawai.service';
import { MainService } from '../../../core/main.service';
import { CreatePegawaiInput } from '../dto/create-pegawai.input';
export declare class PegawaiService extends MainService<Pegawai> implements InterfacePegawaiService<Pegawai> {
    private _pegawaiRepository;
    constructor(_pegawaiRepository: InterfacePegawaiRepository<Pegawai>);
    findByNipOrName(keyword: string, instansiId?: string): Promise<Pegawai[]>;
    findAllWithWorkSchedule(date: string, instansiId?: string): Promise<Pegawai[]>;
    findAllWithWorkScheduleMonthYear(month: string, year: string, instansiId?: string): Promise<Pegawai[]>;
    findAllWithPagination(perPage: number, page: number, instansiId?: string | null, search?: string | null): Promise<[Pegawai[], number]>;
    doCreate(data: CreatePegawaiInput): Promise<Pegawai>;
}
