"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RiwayatPresensiRepository = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const main_repository_1 = require("../../../core/main.repository");
let RiwayatPresensiRepository = class RiwayatPresensiRepository extends main_repository_1.MainRepository {
    _riwayatPresensiRepository;
    constructor(_riwayatPresensiRepository) {
        super();
        this._riwayatPresensiRepository = _riwayatPresensiRepository;
        this.datasource = this._riwayatPresensiRepository;
    }
    async attendanceHistoryWithPagination(perPage, page, pegawaiId = null, instansiId = null, search = null) {
        const qb = this._riwayatPresensiRepository
            .createQueryBuilder('riwayat')
            .leftJoinAndSelect('riwayat.pegawai', 'pegawai')
            .leftJoinAndSelect('pegawai.instansi', 'instansi')
            .orderBy('riwayat.riwayat_presensi_tanggal', 'DESC')
            .addOrderBy('riwayat.riwayat_presensi_jam', 'DESC')
            .addOrderBy('pegawai.pegawai_nama', 'ASC')
            .skip((page - 1) * perPage)
            .take(perPage);
        if (pegawaiId) {
            qb.andWhere('riwayat.pegawai_id = :pegawaiId', { pegawaiId });
        }
        if (instansiId) {
            qb.andWhere('pegawai.instansi_id = :instansiId', { instansiId });
        }
        if (search) {
            qb.andWhere(`(LOWER(pegawai.pegawai_nama) LIKE LOWER(:search) OR LOWER(pegawai.pegawai_nip) LIKE LOWER(:search))`, { search: `%${search}%` });
        }
        const [data, total] = await qb.getManyAndCount();
        return [data, total];
    }
};
exports.RiwayatPresensiRepository = RiwayatPresensiRepository;
exports.RiwayatPresensiRepository = RiwayatPresensiRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('RIWAYAT_PRESENSI_DATASOURCE')),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], RiwayatPresensiRepository);
