"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RiwayatPresensiResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const riwayat_presensi_entity_1 = require("./entities/riwayat_presensi.entity");
const common_1 = require("@nestjs/common");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const role_decorator_1 = require("../auth/decorators/role.decorator");
const constants_1 = require("../auth/constants");
const riwayat_presensi_by_instansi_pagination_get_1 = require("./dto/riwayat-presensi-by-instansi-pagination.get");
let RiwayatPresensiResolver = class RiwayatPresensiResolver {
    _riwayatPresensiService;
    constructor(_riwayatPresensiService) {
        this._riwayatPresensiService = _riwayatPresensiService;
    }
    findAll(pegawaiId) {
        let where = {};
        if (pegawaiId) {
            where = {
                ...where,
                pegawai_id: pegawaiId,
            };
        }
        return this._riwayatPresensiService.findAll(where);
    }
    async attendanceHistoriesWithPagination(page, perPage, pegawaiId, instansiId, search) {
        const [data, total] = await this._riwayatPresensiService.attendanceHistoriesWithPagination(perPage, page, pegawaiId, instansiId, search);
        return {
            data,
            total,
        };
    }
    async updateAttendanceHistoryStatus(riwayat_presensi_id) {
        return this._riwayatPresensiService.switchAttendanceHistoryStatus(riwayat_presensi_id);
    }
    async updateAttendanceHistorySendToAttendance(riwayat_presensi_id) {
        return this._riwayatPresensiService.sendToAttendance(riwayat_presensi_id);
    }
};
exports.RiwayatPresensiResolver = RiwayatPresensiResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.ADMIN_INSTANSI, constants_1.UserLevel.SUPER_ADMIN),
    (0, graphql_1.Query)(() => [riwayat_presensi_entity_1.RiwayatPresensi], { name: 'attendanceHistories' }),
    __param(0, (0, graphql_1.Args)('pegawaiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], RiwayatPresensiResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => riwayat_presensi_by_instansi_pagination_get_1.RiwayatPresensiByInstansiPaginationGet, {
        name: 'attendanceHistoriesWithPagination',
    }),
    __param(0, (0, graphql_1.Args)('page', { type: () => graphql_1.Int })),
    __param(1, (0, graphql_1.Args)('perPage', { type: () => graphql_1.Int })),
    __param(2, (0, graphql_1.Args)('pegawaiId', { type: () => String, nullable: true })),
    __param(3, (0, graphql_1.Args)('instansiId', { type: () => String, nullable: true })),
    __param(4, (0, graphql_1.Args)('search', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String, String]),
    __metadata("design:returntype", Promise)
], RiwayatPresensiResolver.prototype, "attendanceHistoriesWithPagination", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.ADMIN_INSTANSI, constants_1.UserLevel.SUPER_ADMIN),
    (0, graphql_1.Mutation)(() => riwayat_presensi_entity_1.RiwayatPresensi, { name: 'updateAttendanceHistoryStatus' }),
    __param(0, (0, graphql_1.Args)('riwayatPresensiId', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], RiwayatPresensiResolver.prototype, "updateAttendanceHistoryStatus", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.ADMIN_INSTANSI, constants_1.UserLevel.SUPER_ADMIN),
    (0, graphql_1.Mutation)(() => riwayat_presensi_entity_1.RiwayatPresensi, {
        name: 'updateAttendanceHistorySendToAttendance',
    }),
    __param(0, (0, graphql_1.Args)('riwayatPresensiId', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], RiwayatPresensiResolver.prototype, "updateAttendanceHistorySendToAttendance", null);
exports.RiwayatPresensiResolver = RiwayatPresensiResolver = __decorate([
    (0, graphql_1.Resolver)(() => riwayat_presensi_entity_1.RiwayatPresensi),
    __param(0, (0, common_1.Inject)('IRiwayatPresensiService')),
    __metadata("design:paramtypes", [Object])
], RiwayatPresensiResolver);
