"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RiwayatPresensiService = void 0;
const common_1 = require("@nestjs/common");
const main_service_1 = require("../../../core/main.service");
const riwayat_presensi_entity_1 = require("../entities/riwayat_presensi.entity");
let RiwayatPresensiService = class RiwayatPresensiService extends main_service_1.MainService {
    _riwayatPresensiRepository;
    _kehadiranService;
    constructor(_riwayatPresensiRepository, _kehadiranService) {
        super();
        this._riwayatPresensiRepository = _riwayatPresensiRepository;
        this._kehadiranService = _kehadiranService;
        this.repository = this._riwayatPresensiRepository;
    }
    attendanceHistoriesWithPagination(perPage, page, pegawaiId = null, instansiId = null, search = null) {
        return this._riwayatPresensiRepository.attendanceHistoryWithPagination(perPage, page, pegawaiId, instansiId, search);
    }
    async sendToAttendance(id) {
        const riwayat = await this.findOne({ id });
        if (!riwayat) {
            throw new common_1.BadRequestException('Data riwayat presensi tidak ditemukan');
        }
        const attendanceInput = {
            jadwal_kerja_presensi_jam: riwayat.riwayat_presensi_jam,
            jadwal_kerja_presensi_status: riwayat.riwayat_presensi_status,
            jadwal_kerja_presensi_tanggal: riwayat.riwayat_presensi_tanggal,
        };
        await this._kehadiranService.doAttendanceMe(riwayat.pegawai_id, attendanceInput, true);
        await this.destroy(riwayat.id);
        return riwayat;
    }
    async switchAttendanceHistoryStatus(id) {
        let getAttendanceHistory = await this.findOne({
            id,
        });
        if (!getAttendanceHistory)
            throw new common_1.BadRequestException('Riwayat presensi tidak ditemukan');
        getAttendanceHistory.riwayat_presensi_status =
            getAttendanceHistory.riwayat_presensi_status === 'in' ? 'out' : 'in';
        return (await this.update(id, getAttendanceHistory));
    }
    doCreate(data) {
        const riwayatPresensi = new riwayat_presensi_entity_1.RiwayatPresensi();
        riwayatPresensi.pegawai_id = data.pegawai_id;
        riwayatPresensi.riwayat_presensi_jam = data.riwayat_presensi_jam;
        riwayatPresensi.riwayat_presensi_status = data.riwayat_presensi_status;
        riwayatPresensi.riwayat_presensi_tanggal = data.riwayat_presensi_tanggal;
        return this.create(riwayatPresensi);
    }
};
exports.RiwayatPresensiService = RiwayatPresensiService;
exports.RiwayatPresensiService = RiwayatPresensiService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IRiwayatPresensiRepository')),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => 'IKehadiranService'))),
    __metadata("design:paramtypes", [Object, Object])
], RiwayatPresensiService);
