"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SkemaPresensiResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const skema_presensi_entity_1 = require("./entities/skema-presensi.entity");
const common_1 = require("@nestjs/common");
const create_skema_presensi_input_1 = require("./dto/create-skema-presensi.input");
const update_skema_presensi_input_1 = require("./dto/update-skema-presensi.input");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
let SkemaPresensiResolver = class SkemaPresensiResolver {
    _skemaPresensiService;
    constructor(_skemaPresensiService) {
        this._skemaPresensiService = _skemaPresensiService;
    }
    createPresenceScheme(createSkemaPresensiInput) {
        return this._skemaPresensiService.doCreate(createSkemaPresensiInput);
    }
    async findAll(instansiId) {
        let where = {};
        if (instansiId) {
            where = {
                ...where,
                instansi_id: instansiId,
            };
        }
        return this._skemaPresensiService.findAll(where);
    }
    findOne(skema_presensi_id) {
        return this._skemaPresensiService.findOne({ id: skema_presensi_id });
    }
    updatePresenceScheme(skema_presensi_id, updateSkemaPresensiInput) {
        return this._skemaPresensiService.update(skema_presensi_id, updateSkemaPresensiInput);
    }
    removePresenceScheme(skema_presensi_id) {
        return this._skemaPresensiService.destroy(skema_presensi_id);
    }
};
exports.SkemaPresensiResolver = SkemaPresensiResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => skema_presensi_entity_1.SkemaPresensi),
    __param(0, (0, graphql_1.Args)('createSkemaPresensiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_skema_presensi_input_1.CreateSkemaPresensiInput]),
    __metadata("design:returntype", void 0)
], SkemaPresensiResolver.prototype, "createPresenceScheme", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [skema_presensi_entity_1.SkemaPresensi], { name: 'presenceSchemes' }),
    __param(0, (0, graphql_1.Args)('instansiId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SkemaPresensiResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => skema_presensi_entity_1.SkemaPresensi, { name: 'presenceScheme', nullable: true }),
    __param(0, (0, graphql_1.Args)('skema_presensi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SkemaPresensiResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => skema_presensi_entity_1.SkemaPresensi),
    __param(0, (0, graphql_1.Args)('skema_presensi_id', { type: () => String })),
    __param(1, (0, graphql_1.Args)('updateSkemaPresensiInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_skema_presensi_input_1.UpdateSkemaPresensiInput]),
    __metadata("design:returntype", void 0)
], SkemaPresensiResolver.prototype, "updatePresenceScheme", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Mutation)(() => skema_presensi_entity_1.SkemaPresensi),
    __param(0, (0, graphql_1.Args)('skema_presensi_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SkemaPresensiResolver.prototype, "removePresenceScheme", null);
exports.SkemaPresensiResolver = SkemaPresensiResolver = __decorate([
    (0, graphql_1.Resolver)(() => skema_presensi_entity_1.SkemaPresensi),
    __param(0, (0, common_1.Inject)('ISkemaPresensiService')),
    __metadata("design:paramtypes", [Object])
], SkemaPresensiResolver);
