"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const graphql_1 = require("@nestjs/graphql");
const typeorm_1 = require("typeorm");
const encrypt_helpers_1 = require("../../../core/helpers/encrypt.helpers");
const instansi_entity_1 = require("../../instansi/entities/instansi.entity");
const pegawai_entity_1 = require("../../pegawai/entities/pegawai.entity");
let User = class User {
    id;
    user_level_id;
    user_nama;
    user_username;
    user_password;
    instansi_id;
    pegawai_id;
    user_refresh_token;
    user_mobile_device_id;
    instansi;
    pegawai;
    async updateUserPassword() {
        this.user_password = await (0, encrypt_helpers_1.encrypt)(this.user_password);
    }
    async encryptPasswordOnUpdate() {
        if (this.user_password && !this.user_password.startsWith('$2b$')) {
            this.user_password = await (0, encrypt_helpers_1.encrypt)(this.user_password);
        }
    }
};
exports.User = User;
__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', {
        generated: 'uuid',
        name: 'user_id',
    }),
    (0, graphql_1.Field)(() => graphql_1.ID, {
        name: 'user_id',
    }),
    __metadata("design:type", String)
], User.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, graphql_1.Field)(() => String),
    __metadata("design:type", String)
], User.prototype, "user_level_id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, graphql_1.Field)(() => String),
    __metadata("design:type", String)
], User.prototype, "user_nama", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, graphql_1.Field)(() => String),
    __metadata("design:type", String)
], User.prototype, "user_username", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], User.prototype, "user_password", void 0);
__decorate([
    (0, typeorm_1.Column)({
        nullable: true,
    }),
    (0, graphql_1.Field)(() => String, { nullable: true }),
    __metadata("design:type", String)
], User.prototype, "instansi_id", void 0);
__decorate([
    (0, typeorm_1.Column)({
        nullable: true,
        unique: true,
    }),
    (0, graphql_1.Field)(() => String, { nullable: true }),
    __metadata("design:type", String)
], User.prototype, "pegawai_id", void 0);
__decorate([
    (0, typeorm_1.Column)({
        nullable: true,
    }),
    (0, graphql_1.Field)(() => String, { nullable: true }),
    __metadata("design:type", String)
], User.prototype, "user_refresh_token", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "text",
        nullable: true,
    }),
    (0, graphql_1.Field)(() => String, { nullable: true }),
    __metadata("design:type", Object)
], User.prototype, "user_mobile_device_id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => instansi_entity_1.Instansi, (instansi) => instansi.users),
    (0, typeorm_1.JoinColumn)({
        name: 'instansi_id'
    }),
    (0, graphql_1.Field)(() => instansi_entity_1.Instansi, { nullable: true }),
    __metadata("design:type", instansi_entity_1.Instansi)
], User.prototype, "instansi", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => pegawai_entity_1.Pegawai, (pegawai) => pegawai.user, {
        nullable: true,
        eager: true,
    }),
    (0, typeorm_1.JoinColumn)({
        name: 'pegawai_id',
        referencedColumnName: 'id',
    }),
    (0, graphql_1.Field)(() => pegawai_entity_1.Pegawai, { nullable: true }),
    __metadata("design:type", pegawai_entity_1.Pegawai)
], User.prototype, "pegawai", void 0);
__decorate([
    (0, typeorm_1.BeforeInsert)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], User.prototype, "updateUserPassword", null);
__decorate([
    (0, typeorm_1.BeforeUpdate)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], User.prototype, "encryptPasswordOnUpdate", null);
exports.User = User = __decorate([
    (0, typeorm_1.Entity)('tb_user'),
    (0, graphql_1.ObjectType)()
], User);
