"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserService = void 0;
const common_1 = require("@nestjs/common");
const user_entity_1 = require("../entities/user.entity");
const main_service_1 = require("../../../core/main.service");
let UserService = class UserService extends main_service_1.MainService {
    _userRepository;
    constructor(_userRepository) {
        super();
        this._userRepository = _userRepository;
        this.repository = this._userRepository;
    }
    async doChangePassword(userId, data) {
        const user = await this._userRepository.findOne({ id: userId });
        if (!user) {
            throw new common_1.NotFoundException('User tidak ditemukan');
        }
        user.user_password = data.user_password;
        return (await this._userRepository.update(userId, user));
    }
    async doCreate(data) {
        if (data.user_level_id === '7810b031-34d3-4cee-b10d-79604e20126d') {
            const pegawaiTaken = await this._userRepository.findOne({
                pegawai_id: data.pegawai_id,
            });
            if (pegawaiTaken) {
                throw new common_1.BadRequestException('Pegawai sudah memiliki akun pengguna');
            }
        }
        const existing = await this._userRepository.findOne({
            user_username: data.user_username,
        });
        if (existing) {
            throw new common_1.BadRequestException('Username sudah digunakan');
        }
        const user = new user_entity_1.User();
        user.instansi_id = data.instansi_id;
        user.pegawai_id = data.pegawai_id;
        user.user_level_id = data.user_level_id;
        user.user_nama = data.user_nama;
        user.user_username = data.user_username;
        user.user_password = data.user_password;
        return this.create(user);
    }
    async doResetUser(userId) {
        const user = await this._userRepository.findOne({ id: userId });
        if (!user)
            throw new common_1.NotFoundException('User tidak ditemukan');
        user.user_mobile_device_id = null;
        return (await this._userRepository.update(userId, user));
    }
};
exports.UserService = UserService;
exports.UserService = UserService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('IUserRepository')),
    __metadata("design:paramtypes", [Object])
], UserService);
