import { User } from './entities/user.entity';
import { InterfaceUserService } from './services/interface.user.service';
import { CreateUserInput } from './dto/create-user.input';
import { UpdateUserInput } from './dto/update-user.input';
import { ChangePasswordUserInput } from './dto/change-password-user.input';
import { Instansi } from '../instansi/entities/instansi.entity';
import { InterfaceInstansiService } from '../instansi/services/interface.instansi.service';
export declare class UserResolver {
    private readonly _userService;
    private readonly _instansiService;
    constructor(_userService: InterfaceUserService<User>, _instansiService: InterfaceInstansiService<Instansi>);
    createUser(createUserInput: CreateUserInput): Promise<User>;
    findAll(userLevelId?: string): Promise<User[]>;
    findOne(user_id: string): Promise<User | null>;
    updateUser(user_id: string, updateUserInput: UpdateUserInput): Promise<User | null>;
    removeUser(user_id: string): Promise<User | null>;
    updateUserChangePassword(userId: string, changePasswordUserInput: ChangePasswordUserInput): Promise<User>;
    insansi(user: User): Promise<Instansi | null>;
    resetUser(user_id: string): Promise<User>;
}
