"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserResolver = void 0;
const graphql_1 = require("@nestjs/graphql");
const user_entity_1 = require("./entities/user.entity");
const common_1 = require("@nestjs/common");
const create_user_input_1 = require("./dto/create-user.input");
const update_user_input_1 = require("./dto/update-user.input");
const auth_guard_jwt_1 = require("../auth/jwt/auth-guard.jwt");
const role_decorator_1 = require("../auth/decorators/role.decorator");
const constants_1 = require("../auth/constants");
const change_password_user_input_1 = require("./dto/change-password-user.input");
const instansi_entity_1 = require("../instansi/entities/instansi.entity");
let UserResolver = class UserResolver {
    _userService;
    _instansiService;
    constructor(_userService, _instansiService) {
        this._userService = _userService;
        this._instansiService = _instansiService;
    }
    createUser(createUserInput) {
        return this._userService.doCreate(createUserInput);
    }
    findAll(userLevelId) {
        let where = {};
        if (userLevelId) {
            where = {
                ...where,
                user_level_id: userLevelId,
            };
        }
        return this._userService.findAll(where);
    }
    findOne(user_id) {
        return this._userService.findOne({ id: user_id });
    }
    updateUser(user_id, updateUserInput) {
        return this._userService.update(user_id, updateUserInput);
    }
    removeUser(user_id) {
        return this._userService.destroy(user_id);
    }
    updateUserChangePassword(userId, changePasswordUserInput) {
        return this._userService.doChangePassword(userId, changePasswordUserInput);
    }
    async insansi(user) {
        const { instansi_id: id } = user;
        return id ? await this._instansiService.findOne({ id }) : null;
    }
    resetUser(user_id) {
        return this._userService.doResetUser(user_id);
    }
};
exports.UserResolver = UserResolver;
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Mutation)(() => user_entity_1.User),
    __param(0, (0, graphql_1.Args)('createUserInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_user_input_1.CreateUserInput]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "createUser", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => [user_entity_1.User], { name: 'users' }),
    __param(0, (0, graphql_1.Args)('userLevelId', { type: () => String, nullable: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.Query)(() => user_entity_1.User, { name: 'user', nullable: true }),
    __param(0, (0, graphql_1.Args)('user_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Mutation)(() => user_entity_1.User),
    __param(0, (0, graphql_1.Args)('user_id', { type: () => String })),
    __param(1, (0, graphql_1.Args)('updateUserInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_user_input_1.UpdateUserInput]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "updateUser", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Mutation)(() => user_entity_1.User),
    __param(0, (0, graphql_1.Args)('user_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "removeUser", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Mutation)(() => user_entity_1.User),
    __param(0, (0, graphql_1.Args)('userId', { type: () => String })),
    __param(1, (0, graphql_1.Args)('changePasswordUserInput')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, change_password_user_input_1.ChangePasswordUserInput]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "updateUserChangePassword", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, graphql_1.ResolveField)(() => instansi_entity_1.Instansi, { name: 'instansi', nullable: true }),
    __param(0, (0, graphql_1.Parent)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", Promise)
], UserResolver.prototype, "insansi", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_jwt_1.AuthGuardJwt),
    (0, role_decorator_1.Roles)(constants_1.UserLevel.SUPER_ADMIN, constants_1.UserLevel.ADMIN_INSTANSI),
    (0, graphql_1.Mutation)(() => user_entity_1.User, { name: 'resetUser' }),
    __param(0, (0, graphql_1.Args)('user_id', { type: () => String })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserResolver.prototype, "resetUser", null);
exports.UserResolver = UserResolver = __decorate([
    (0, graphql_1.Resolver)(() => user_entity_1.User),
    __param(0, (0, common_1.Inject)('IUserService')),
    __param(1, (0, common_1.Inject)('IInstansiService')),
    __metadata("design:paramtypes", [Object, Object])
], UserResolver);
