"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encrypt = encrypt;
exports.compareHash = compareHash;
const bcrypt = require("bcrypt");
async function encrypt(text) {
    const saltOrRounds = 10;
    return await bcrypt.hash(text, saltOrRounds);
}
async function compareHash(password, hash) {
    return await bcrypt.compare(password, hash);
}
