"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sleep = sleep;
exports.isTimeExpired = isTimeExpired;
async function sleep(ms = 2000, status = true) {
    await new Promise((resolve, reject) => setTimeout(status ? resolve : reject, ms));
}
async function isTimeExpired(validUntil) {
    const expiry = new Date(validUntil);
    return isNaN(expiry.getTime()) || new Date() > expiry;
}
