"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentTime = getCurrentTime;
exports.convertToTimeZone = convertToTimeZone;
const luxon_1 = require("luxon");
const DEFAULT_ZONE = 'Asia/Makassar';
function getCurrentTime(zone = DEFAULT_ZONE) {
    return luxon_1.DateTime.now().setZone(zone);
}
function convertToTimeZone(date, zone = DEFAULT_ZONE) {
    return luxon_1.DateTime.fromISO(date.toString()).setZone(zone);
}
