import { ObjectLiteral, Repository } from 'typeorm';
export default interface InterfaceMainRepository<T extends ObjectLiteral> {
    findAll(where?: object): Promise<T[]>;
    findOne(where: object): Promise<T | null>;
    create(data: T): Promise<T>;
    destroy(id: string | number): Promise<T | null>;
    destroyBatch(ids: string[] | number[]): Promise<T[]>;
    update(id: string | number, data: object): Promise<T | null>;
    mainDatasource(): Repository<T>;
}
