"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MainRepository = void 0;
const typeorm_1 = require("typeorm");
const common_1 = require("@nestjs/common");
class MainRepository {
    datasource;
    constructor() { }
    async destroyBatch(ids) {
        const find = await this.datasource.findBy({
            id: (0, typeorm_1.In)(ids.map(String)),
        });
        await this.datasource.delete(ids);
        return find;
    }
    mainDatasource() {
        return this.datasource;
    }
    async update(id, data) {
        await this.datasource.update(id, data);
        return this.findOne({ id: id });
    }
    async destroy(id) {
        const find = await this.datasource.findOne({ where: { id } });
        const result = await this.datasource.delete(id);
        if (!result.affected) {
            throw new common_1.NotFoundException(`Entity with ID "${id}" not found.`);
        }
        return find;
    }
    findAll(where) {
        return this.datasource.find({ where });
    }
    findOne(where) {
        return this.datasource.findOneBy(where);
    }
    async create(data) {
        return this.datasource.save(data);
    }
}
exports.MainRepository = MainRepository;
