"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const platform_fastify_1 = require("@nestjs/platform-fastify");
const app_module_1 = require("./app.module");
const helmet_1 = require("@fastify/helmet");
const csrf_protection_1 = require("@fastify/csrf-protection");
const compress_1 = require("@fastify/compress");
const common_1 = require("@nestjs/common");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule, new platform_fastify_1.FastifyAdapter({ logger: true, trustProxy: true }));
    app.enableCors({
        credentials: true,
        origin: '*',
    });
    await app.register(compress_1.default);
    await app.register(helmet_1.default, {
        crossOriginEmbedderPolicy: false,
        contentSecurityPolicy: {
            directives: {
                imgSrc: [
                    `'self'`,
                    'data:',
                    'apollo-server-landing-page.cdn.apollographql.com',
                ],
                scriptSrc: [`'self'`, `https: 'unsafe-inline'`],
                manifestSrc: [
                    `'self'`,
                    'apollo-server-landing-page.cdn.apollographql.com',
                ],
                frameSrc: [`'self'`, 'sandbox.embed.apollographql.com'],
            },
        },
    });
    await app.register(csrf_protection_1.default);
    app.useGlobalPipes(new common_1.ValidationPipe());
    await app.listen(process.env.PORT ?? 3000, '0.0.0.0');
}
bootstrap().then();
