"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fastifyApolloDrainPlugin = void 0;
function fastifyApolloDrainPlugin(fastify) {
    return {
        async serverWillStart() {
            return {
                async drainServer() {
                    if ("closeAllConnections" in fastify.server) {
                        const timeout = setTimeout(() => {
                            fastify.server.closeAllConnections();
                        }, 10000);
                        await fastify.close();
                        clearTimeout(timeout);
                    }
                },
            };
        },
    };
}
exports.fastifyApolloDrainPlugin = fastifyApolloDrainPlugin;
