"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fastifyRequestToGraphQLRequest = void 0;
const server_1 = require("@apollo/server");
const httpHeadersToMap = (headers) => {
    const map = new server_1.HeaderMap();
    for (const [key, value] of Object.entries(headers)) {
        if (value) {
            map.set(key, Array.isArray(value) ? value.join(", ") : value);
        }
    }
    return map;
};
const fastifyRequestToGraphQLRequest = (request) => ({
    body: request.body,
    method: request.method.toUpperCase(),
    headers: httpHeadersToMap(request.headers),
    search: new URL(request.url, `${request.protocol}://${request.hostname}/`).search,
});
exports.fastifyRequestToGraphQLRequest = fastifyRequestToGraphQLRequest;
